// StereoStarView.h : interface of the CStereoStarView class
// **********************
/////////////////////////////////////////////////////////////////////////////
#ifndef _STEREOSTARVIEW
#define _STEREOSTARVIEW

#include "StarDefs.h"
#include "StereoStarDoc.h"
#include "MainFrm.h"
#include "PerspectiveEngine.h"

#define AXISX	0
#define AXISY	1
#define AXISZ	2
#define NUMAXIS 3

#define PLUSAXIS	0
#define MINUSAXIS	1
#define NUMSIGN		2

#define CLOSEST_LINE	0
#define LIMIT_LINE		1
#define CUSTOM_LINE		2
#define NUM_LINE_TYPES	3

#define O_DEFAULT_COLOR			MAGENTACOLOR
#define B_DEFAULT_COLOR			CYANCOLOR
#define A_DEFAULT_COLOR			BLUECOLOR
#define F_DEFAULT_COLOR			GREENCOLOR
#define G_DEFAULT_COLOR			YELLOWCOLOR
#define K_DEFAULT_COLOR			ORANGECOLOR
#define M_DEFAULT_COLOR			REDCOLOR
#define X_DEFAULT_COLOR			GRAYCOLOR
#define LINE_DEFAULT_COLOR		CYANCOLOR
#define ALT_DEFAULT_COLOR		GRAYCOLOR
#define PLANE_XY_DEFAULT_COLOR	GRAYCOLOR
#define PLANE_XZ_DEFAULT_COLOR	GRAYCOLOR
#define PLANE_YZ_DEFAULT_COLOR	GRAYCOLOR
#define NAME_DEFAULT_COLOR		WHITECOLOR
#define COORD_DEFAULT_COLOR		WHITECOLOR
#define BG_DEFAULT_COLOR		BLACKCOLOR
#define AXIS_DEFAULT_COLOR		GREENCOLOR

// keys to store settings in the registry
#define O_COLOR_KEY				"OColor"		
#define B_COLOR_KEY				"BColor"			
#define A_COLOR_KEY				"AColor"			
#define F_COLOR_KEY				"FColor"			
#define G_COLOR_KEY				"GColor"			
#define K_COLOR_KEY				"KColor"			
#define M_COLOR_KEY				"MColor"			
#define X_COLOR_KEY				"XColor"		
#define LINE_COLOR_KEY			"LineColor"	
#define ALT_COLOR_KEY			"AltColor"
#define PLANE_XY_COLOR_KEY		"PlaneXYColor"
#define PLANE_XZ_COLOR_KEY		"PlaneXZColor"
#define PLANE_YZ_COLOR_KEY		"PlaneYZColor"
#define NAME_COLOR_KEY			"NameColor"
#define COORD_COLOR_KEY			"CoordColor"
#define BG_COLOR_KEY			"BGColor"
#define AXIS_COLOR_KEY			"AxisColor"
#define COORD_TYPE_KEY			"CoordType"
#define VIEW_MODE_KEY			"ViewMode"
#define LINE_LIMIT_KEY			"LineLimit"
#define SHOW_LINE_LIMIT_KEY		"ShowLineLimit"
#define SHOW_LINE_CLOSEST_KEY	"ShowLineClosest"
#define SHOW_CUSTOM_LINES_KEY	"ShowCustomLines"
#define SHOW_LINES_KEY			"ShowLines"
#define SHOW_LINE_ALT_XY_KEY	"ShowLineAltXY"
#define SHOW_LINE_ALT_XZ_KEY	"ShowLineAltXZ"
#define SHOW_LINE_ALT_YZ_KEY	"ShowLineAltYZ"
#define SHOW_COORDS_KEY			"ShowCoords"
#define SHOW_DECIMAL_COORD_KEY	"ShowDecimalCoord"
#define SHOW_NAMES_KEY			"ShowNames"
#define SHOW_BITMAP_STARS_KEY	"ShowBitmapStars"
#define SHOW_LINE_SHADOW_KEY	"ShowLineShadow"
#define SHOW_XY_PLANE_KEY		"ShowXYPlane"
#define SHOW_XZ_PLANE_KEY		"ShowXZPlane"
#define SHOW_YZ_PLANE_KEY		"ShowYZPlane"
#define SHOW_RADIALS_KEY		"ShowRadials"
#define SHOW_XYZ_AXIS_KEY		"ShowXYZAxis"
#define LABEL_LINE_LENGTH_KEY	"LabelLineLength"
#define DISTANCE_FILTER_KEY		"DistanceFilter"
#define DISTANCE_FILTER_LIMIT_KEY "DistanceFilterLimit"
#define SHOW_CLASS_O_KEY		"ShowClassO"
#define SHOW_CLASS_B_KEY		"ShowClassB"
#define SHOW_CLASS_A_KEY		"ShowClassA"
#define SHOW_CLASS_F_KEY		"ShowClassF"
#define SHOW_CLASS_G_KEY		"ShowClassG"
#define SHOW_CLASS_K_KEY		"ShowClassK"
#define SHOW_CLASS_M_KEY		"ShowClassM"
#define SHOW_CLASS_X_KEY		"ShowClassX"
#define NAME_FONT_TYPEFACE_KEY	"NameFontTypeFace"
#define NAME_FONT_POINT_KEY		"NameFontPoint"
#define COORD_FONT_TYPEFACE_KEY	"CoordFontTypeFace"
#define COORD_FONT_POINT_KEY	"CoordFontPoint"

class CStereoStarView : public CScrollView
{
protected: // create from serialization only
	void WriteColorToRegistry(COLORREF theColor, LPCTSTR theColorName);
	void SetDefaultColors();
	short printVertRes;
	short printHorzRes;
	UINT pagesWide;
	BOOL labelLineLength;
	void PlotAxisNo3D(CPaintDC* dc);
	void PlotGridNo3D(CPaintDC* dc);
	BOOL showCoordsCache;
	BOOL showLinesCache;
	BOOL showNamesCache;
	void ConfigureScrolling();
	void SetScrollToScreenSize();
	void SetScrollToDocSize();
	CRect offscreenRect;
	void ChangeScrollSize(CSize newSize);
	CStereoStarView();

// Attributes
public:
	void	InitializeNameRects();
	void	InitializeLine();
	COLORREF ReadColorFromRegister(LPCTSTR theColorName, COLORREF defaultColor);
	DECLARE_SERIAL(CStereoStarView)
	void CalcOriginDist();
	void Serialize(CArchive& ar);
	void UpdateScaleFactor(double newFactor);
	void UpdateViewAngle(double newAngle);
	CStereoStarDoc* GetDocument();
	short				coordType;
	double		TrueDistance(TriPoint *pointA, TriPoint *pointB);
	double		SquareDistance(TriPoint *pointA, TriPoint *pointB);

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CStereoStarView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CStereoStarView();
	BOOL StarVisible(short starNum);
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	void		CalcEye();
	void		CalcLine();
	void		ChangeScaleFactor(double newFactor);
	void		GetAxis();
	void		OnSpinscalePressed();
	void		OnSpinscaleUnpressed();

protected:

private:
	// serialized variables
	short				viewMode;
	BOOL				showNames;
	BOOL				showLines;
	double				lineLimit;
	BOOL				showLine[NUM_LINE_TYPES];
	BOOL				showXYZAxis;
	BOOL				showPlane[NUMPLANES];
	BOOL				showLineAlt[NUMPLANES];
	BOOL				showLineShadow;
	BOOL				showRadials;
	BOOL				showCoords;
						// coordType is a public variable
	BOOL				showClass[NUM_CLASSES];
	BOOL				showBitmapStars;
	double				scaleFactor[NUMSCALES];
	short				scaleMode;
	COLORREF			currentBackgroundColor;
	COLORREF			currentLineColor;
	COLORREF			currentNameColor;
	COLORREF			currentCoordColor;
	COLORREF			currentAltLineColor;
	COLORREF			spectralColor[NUM_CLASSES];
	COLORREF			currentPlaneColor[NUMPLANES];
	COLORREF			currentAxisColor;
	CFont*				nameFont;
	CFont*				coordFont;
	BOOL				showDecimalCoord;
	double				distanceFilterLimit;
	BOOL				distanceFilter;
	// end of serialized variables
	CMainFrame*			theMainFrame;
	CRect				theClientRect;
	void				GetFont(CFont* theFont, COLORREF* currentColor, CString* fontTypeFace, int* fontPoints);
	COLORREF			GetColor(COLORREF currentColor);
	COLORREF			anaglyphColor[NUMEYES];
	TriPoint			axisCoords[NUMAXIS][NUMSIGN][NUMCOORDSYSTEMS];
	DuoPoint			axis[NUMAXIS][NUMSIGN][NUMEYES];
	DuoPoint			plane[NUMPLANES][NUMCORNERS][NUMEYES]; 
	CBitmap*			offscreenBitMap;
	CBitmap				*pOldOffscreenBmp;
	CDC					offscreenDC;
	BOOL				offscreenDCInit;
	CStereoStarDoc*		theDoc;
	short				SX;
	short				SY;
	short				SCX;
	short				SCY;
	short				SCXL;
	short				SCXR;
	CPtrList			theEye[NUMEYES];
	CObList				lines[NUM_LINE_TYPES];
	CPtrList			altitude[NUMEYES];
	DuoPoint			planeCenter[NUMEYES];
	CPerspectiveEngine	*perspectiveEngine;
	short				scx[NUMEYES][NUMMODES];
	CBitmap				starImage[NUM_CLASSES];

	CRgn		textRgn;
	BOOL		textRgnInit;


	void		CreateBMPFile(HWND hwnd, LPCTSTR pszFile, PBITMAPINFO pbi, HBITMAP hBMP, HDC hDC);
	PBITMAPINFO CreateBitmapInfoStruct(HWND hwnd, BITMAP* bmp);
	void		Calc3D(short eyeID);
	void		LineLimit();
	void		LineClosest();
	double		Mag(TriPoint *v);
	TriPoint	Subtract(TriPoint *v1, TriPoint *v2);
	TriPoint	Cross(TriPoint *v1, TriPoint *v2);
	TriPoint	Divide(TriPoint *v, double num);
	double		MakeRadians(double degrees);
	void		DrawStar(CPaintDC* dc, short starNum, double plotX, double plotY, COLORREF theColor);
	void		DrawLine(CPaintDC* dc, double startX, double startY, double endX, double endY, COLORREF theColor);
	void		DrawName(CPaintDC* dc, short starNum, double plotX, double plotY, COLORREF theNameColor, COLORREF theCoordColor);
	void		PlotStar(CPaintDC* dc);
	void		PlotLine(CPaintDC* dc);
	void		EmptyEyeLists();
	void		EmptyLineList(int lineType);
	void		EmptyAllLineLists();
	void		EmptyAltLists();
	void		PlotAxisCrossWide(CPaintDC* dc);
	void		PlotAxisAnaglyph(CPaintDC* dc);
	void		UpdateOffscreenBitmap();
	void		ChangeScreenDimensions(short newWidth, short newHeight);
	void		PlotAltCrossWide(CPaintDC* dc);
	void		PlotAltAnaglyph(CPaintDC* dc);
	double		ScaleX(double locX, int eyeID = LEFT);
	double		ScaleY(double locY);
	CRect		GetUnobscuredTextLocation(int centerX, int centerY, CSize textSize, int* justification);


// Generated message map functions
protected:
	CBitmap classOBitmap;
	CBitmap classBBitmap;
	CBitmap classABitmap;
	CBitmap classFBitmap;
	CBitmap classGBitmap;
	CBitmap classKBitmap;
	CBitmap classMBitmap;
	CBitmap classXBitmap;
	void TransparentBlt( HDC hdcDest, int nXDest, int nYDest, int nWidth, int nHeight, HBITMAP hBitmap, int nXSrc, int nYSrc, COLORREF colorTransparent, HPALETTE hPal );
	//{{AFX_MSG(CStereoStarView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnShowCoords();
	afx_msg void OnUpdateShowCoordsMenu(CCmdUI* pCmdUI);
	afx_msg void OnShowClosestNeighbor();
	afx_msg void OnUpdateClosestNeighborMenu(CCmdUI* pCmdUI);
	afx_msg void OnSetTheLimit();
	afx_msg void OnShowWithinSetLimit();
	afx_msg void OnUpdateWithinSetLimitMenu(CCmdUI* pCmdUI);
	afx_msg void OnSetEquitorialCoords();
	afx_msg void OnUpdateEquitorialCoordsMenu(CCmdUI* pCmdUI);
	afx_msg void OnSetGalacticCoords();
	afx_msg void OnUpdateGalacticCoordsMenu(CCmdUI* pCmdUI);
	afx_msg void OnShowLines();
	afx_msg void OnUpdateShowLinesMenu(CCmdUI* pCmdUI);
	afx_msg void OnSetScaleFactor();
	afx_msg void OnShowNames();
	afx_msg void OnUpdateShowNamesMenu(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonAnaglyph(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonCrosseye(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonNo3d(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonWideeye(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonEquitorial(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonGalactic(CCmdUI* pCmdUI);
	afx_msg void OnViewShowDecimals();
	afx_msg void OnUpdateViewShowDecimals(CCmdUI* pCmdUI);
	afx_msg void OnStarImageCrosshairs();
	afx_msg void OnUpdateStarImageCrosshairs(CCmdUI* pCmdUI);
	afx_msg void OnStarImagePictures();
	afx_msg void OnUpdateStarImagePictures(CCmdUI* pCmdUI);
	afx_msg void OnAltitudeLine();
	afx_msg void OnUpdateAltitudeLine(CCmdUI* pCmdUI);
	afx_msg void OnShowXYPane();
	afx_msg void OnUpdateShowxXYPlane(CCmdUI* pCmdUI);
	afx_msg void OnLineShadow();
	afx_msg void OnUpdateLineShadow(CCmdUI* pCmdUI);
	afx_msg void OnSetLineColor();
	afx_msg void OnSetAltitudeLineColor();
	afx_msg void OnSetNameColor();
	afx_msg void OnSetBackgroundColor();
	afx_msg void OnSetCoordColor();
	afx_msg void OnSetCoordFont();
	afx_msg void OnSetNameFont();
	afx_msg void OnSaveAsBitmap();
	afx_msg void OnSetXYPlaneColor();
	afx_msg void OnSetViewAngle();
	afx_msg void OnUpdateSetViewAngle(CCmdUI* pCmdUI);
	afx_msg void OnSetEyeSeparation();
	afx_msg void OnUpdateSetEyeSeparation(CCmdUI* pCmdUI);
	afx_msg void OnSetLineTypesRadials();
	afx_msg void OnUpdateSetLineTypesRadials(CCmdUI* pCmdUI);
	afx_msg void OnColorSetaxiscolor();
	afx_msg void OnUpdateXYZAxis(CCmdUI* pCmdUI);
	afx_msg void OnXYZAxis();
	afx_msg void OnShowXZplane();
	afx_msg void OnUpdateShowXZplane(CCmdUI* pCmdUI);
	afx_msg void OnShowYZplane();
	afx_msg void OnUpdateShowYZplane(CCmdUI* pCmdUI);
	afx_msg void OnSetXZPaneColor();
	afx_msg void OnSetYZPlaneColor();
	afx_msg void OnSetCoordOrigin();
	afx_msg void OnExcludeStarsTooDistant();
	afx_msg void OnUpdateExcludeStarsTooDistant(CCmdUI* pCmdUI);
	afx_msg void OnSetFilterDistance();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLabelLineLengths();
	afx_msg void OnUpdateLabelLineLengths(CCmdUI* pCmdUI);
	afx_msg void OnLineWizard();
	afx_msg void OnUpdateLineWizard(CCmdUI* pCmdUI);
	afx_msg void OnCustomizedLines();
	afx_msg void OnUpdateCustomizedLines(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSetTheLimit(CCmdUI* pCmdUI);
	afx_msg void OnColorResetToDefault();
	afx_msg void OnFileLoadCustomLines();
	afx_msg void OnFileSaveCustomLines();
	//}}AFX_MSG
	afx_msg void OnUpdateCoordType(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewMode(CCmdUI* pCmdUI);
	afx_msg void OnUpdateScaleFactor(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewAngle(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEyeSeparation(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLineLimit(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEyeLoc(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSpinThetaToolbar(CCmdUI* pCmdUI);
	afx_msg void OnSpinTheta(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSpinPhiToolbar(CCmdUI* pCmdUI);
	afx_msg void OnSpinPhi(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSpinRhoToolbar(CCmdUI* pCmdUI);
	afx_msg void OnSpinRho(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSpinScaleToolbar(CCmdUI* pCmdUI);
	afx_msg void OnSpinScale(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSpinViewAngleToolbar(CCmdUI* pCmdUI);
	afx_msg void OnSpinViewAngle(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSpinEyeSepToolbar(CCmdUI* pCmdUI);
	afx_msg void OnSpinEyeSep(CCmdUI* pCmdUI);
    afx_msg void SetDisplayMode(UINT nID);
    afx_msg void UpdateDisplayModeMenu(CCmdUI* pCmdUI);
    afx_msg void UpdateDisplayModeButton(CCmdUI* pCmdUI);
    afx_msg void ShowSpectralClass(UINT nID);
    afx_msg void UpdateSpectralClass(CCmdUI* pCmdUI);
    afx_msg void SetSpectralColor(UINT nID);
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in StereoStarView.cpp
inline CStereoStarDoc* CStereoStarView::GetDocument()
   { return (CStereoStarDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
#endif
