// StereoStarView.cpp : implementation of the CStereoStarView class
//
// **** WARNING!!! ****
// if you are compiling this from MSVC++ 4.2 or earlier, do NOT use the
// full optimization switch ( /Ox ) without using the -Op switch.
// Otherwise the trigonmetric functions will return incorrect values.


#include "stdafx.h"
#include "StereoStar.h"

#include "StereoStarDoc.h"
#include "StereoStarView.h"
#include "SetLineLimitDlog.h"
#include "ScaleFactorDlog.h"
#include "ViewAngleDialog.h"
#include "EyeSeparationDialog.h"
#include <math.h>
#include "SetOriginDialog.h"
#include "SetOriginDistanceDialog.h"
#include "ResetColorDialog.h"
#include "CStarLine.h"
#include "ProgressDialog.h"
#include "PerspectiveEngine.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CStereoStarApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CStereoStarView

IMPLEMENT_SERIAL(CStereoStarView, CScrollView, 0x100)

BEGIN_MESSAGE_MAP(CStereoStarView, CScrollView)
	//{{AFX_MSG_MAP(CStereoStarView)
	ON_WM_SIZE()
	ON_COMMAND(ID_VIEW_SHOWCOORDS, OnShowCoords)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWCOORDS, OnUpdateShowCoordsMenu)
	ON_COMMAND(ID_VIEW_SHOWLINES_CLOSESTNEIGHBOR, OnShowClosestNeighbor)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWLINES_CLOSESTNEIGHBOR, OnUpdateClosestNeighborMenu)
	ON_COMMAND(ID_VIEW_SHOWLINES_SETTHELIMIT, OnSetTheLimit)
	ON_COMMAND(ID_VIEW_SHOWLINES_WITHINSETLIMIT, OnShowWithinSetLimit)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWLINES_WITHINSETLIMIT, OnUpdateWithinSetLimitMenu)
	ON_COMMAND(ID_VIEW_SETCOORDTYPE_EQUITORIALCOORDS, OnSetEquitorialCoords)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETCOORDTYPE_EQUITORIALCOORDS, OnUpdateEquitorialCoordsMenu)
	ON_COMMAND(ID_VIEW_SETCOORDTYPE_GALACTICCOORDS, OnSetGalacticCoords)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETCOORDTYPE_GALACTICCOORDS, OnUpdateGalacticCoordsMenu)
	ON_COMMAND(ID_VIEW_SHOWLINES, OnShowLines)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWLINES, OnUpdateShowLinesMenu)
	ON_COMMAND(ID_VIEW_SETSCALEFACTOR, OnSetScaleFactor)
	ON_COMMAND(ID_VIEW_SHOWNAMES, OnShowNames)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWNAMES, OnUpdateShowNamesMenu)
	ON_UPDATE_COMMAND_UI(ID_BUTTON_EQUITORIAL, OnUpdateButtonEquitorial)
	ON_UPDATE_COMMAND_UI(ID_BUTTON_GALACTIC, OnUpdateButtonGalactic)
	ON_COMMAND(ID_VIEW_SETCOORDTYPE_SHOWDECIMALS, OnViewShowDecimals)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETCOORDTYPE_SHOWDECIMALS, OnUpdateViewShowDecimals)
	ON_COMMAND(ID_VIEW_STARIMAGE_CROSSHAIRS, OnStarImageCrosshairs)
	ON_UPDATE_COMMAND_UI(ID_VIEW_STARIMAGE_CROSSHAIRS, OnUpdateStarImageCrosshairs)
	ON_COMMAND(ID_VIEW_STARIMAGE_PICTURES, OnStarImagePictures)
	ON_UPDATE_COMMAND_UI(ID_VIEW_STARIMAGE_PICTURES, OnUpdateStarImagePictures)
	ON_COMMAND(ID_VIEW_SETLINETYPES_ALTITUDEFROMXYPLANE, OnAltitudeLine)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETLINETYPES_ALTITUDEFROMXYPLANE, OnUpdateAltitudeLine)
	ON_COMMAND(ID_VIEW_SHOWXYPLANE, OnShowXYPane)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWXYPLANE, OnUpdateShowxXYPlane)
	ON_COMMAND(ID_VIEW_SETLINETYPES_LINESHADOWONXYPLANE, OnLineShadow)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETLINETYPES_LINESHADOWONXYPLANE, OnUpdateLineShadow)
	ON_COMMAND(ID_COLOR_SETLINECOLOR, OnSetLineColor)
	ON_COMMAND(ID_COLOR_SETALTITUDELINECOLOR, OnSetAltitudeLineColor)
	ON_COMMAND(ID_COLOR_SETNAMECOLOR, OnSetNameColor)
	ON_COMMAND(ID_COLOR_SETBACKGROUNDCOLOR, OnSetBackgroundColor)
	ON_COMMAND(ID_COLOR_SETCOORDCOLOR, OnSetCoordColor)
	ON_COMMAND(ID_FONTS_SETCOORDFONT, OnSetCoordFont)
	ON_COMMAND(ID_FONTS_SETNAMEFONT, OnSetNameFont)
	ON_COMMAND(ID_FILE_SAVEASBITMAP, OnSaveAsBitmap)
	ON_COMMAND(ID_COLOR_SETXYPLANECOLOR, OnSetXYPlaneColor)
	ON_COMMAND(ID_VIEW_SETVIEWANGLE, OnSetViewAngle)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETVIEWANGLE, OnUpdateSetViewAngle)
	ON_COMMAND(ID_VIEW_SETEYESEPARATION, OnSetEyeSeparation)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETEYESEPARATION, OnUpdateSetEyeSeparation)
	ON_COMMAND(ID_VIEW_SETLINETYPES_RADIALSONXYPLANE, OnSetLineTypesRadials)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETLINETYPES_RADIALSONXYPLANE, OnUpdateSetLineTypesRadials)
	ON_COMMAND(ID_COLOR_SETAXISCOLOR, OnColorSetaxiscolor)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETLINETYPES_SHOWXYZAXIS, OnUpdateXYZAxis)
	ON_COMMAND(ID_VIEW_SETLINETYPES_SHOWXYZAXIS, OnXYZAxis)
	ON_COMMAND(ID_VIEW_SHOWXZPLANE, OnShowXZplane)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWXZPLANE, OnUpdateShowXZplane)
	ON_COMMAND(ID_VIEW_SHOWYZPLANE, OnShowYZplane)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWYZPLANE, OnUpdateShowYZplane)
	ON_COMMAND(ID_COLOR_SETXZPLANECOLOR, OnSetXZPaneColor)
	ON_COMMAND(ID_COLOR_SETYZPLANECOLOR, OnSetYZPlaneColor)
	ON_COMMAND(ID_VIEW_SETCOORDORIGIN, OnSetCoordOrigin)
	ON_COMMAND(ID_VIEW_FILTERBYDISTANCE_EXCLUDESTARSTOODISTANT, OnExcludeStarsTooDistant)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FILTERBYDISTANCE_EXCLUDESTARSTOODISTANT, OnUpdateExcludeStarsTooDistant)
	ON_COMMAND(ID_VIEW_FILTERBYDISTANCE_SETDISTANCE, OnSetFilterDistance)
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_VIEW_LABELLINELENGTHS, OnLabelLineLengths)
	ON_UPDATE_COMMAND_UI(ID_VIEW_LABELLINELENGTHS, OnUpdateLabelLineLengths)
	ON_COMMAND(ID_VIEW_SETLINETYPES_LINEWIZARD, OnLineWizard)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETLINETYPES_LINEWIZARD, OnUpdateLineWizard)
	ON_COMMAND(ID_VIEW_SETLINETYPES_CUSTOMIZED, OnCustomizedLines)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SETLINETYPES_CUSTOMIZED, OnUpdateCustomizedLines)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWLINES_SETTHELIMIT, OnUpdateSetTheLimit)
	ON_COMMAND(ID_COLOR_RESETTODEFAULTCOLORS, OnColorResetToDefault)
	ON_COMMAND(ID_BUTTON_EQUITORIAL, OnSetEquitorialCoords)
	ON_COMMAND(ID_BUTTON_GALACTIC, OnSetGalacticCoords)
	ON_COMMAND(ID_FILE_LOADCUSTOMLINES, OnFileLoadCustomLines)
	ON_COMMAND(ID_FILE_SAVECUSTOMLINES, OnFileSaveCustomLines)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_COORDTYPE, OnUpdateCoordType)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_VIEWMODE, OnUpdateViewMode)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_SCALEFACTOR, OnUpdateScaleFactor)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_VIEWANGLE, OnUpdateViewAngle)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_EYESEPARATION, OnUpdateEyeSeparation)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_LINELIMIT, OnUpdateLineLimit)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_EYELOC, OnUpdateEyeLoc)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_THETA_VALUE, OnSpinTheta)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_THETA_TOOLBAR, OnUpdateSpinThetaToolbar)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_PHI_VALUE, OnSpinPhi)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_PHI_TOOLBAR, OnUpdateSpinPhiToolbar)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_RHO_VALUE, OnSpinRho)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_RHO_TOOLBAR, OnUpdateSpinRhoToolbar)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_SCALE_VALUE, OnSpinScale)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_SCALE_TOOLBAR, OnUpdateSpinScaleToolbar)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_VIEWANGLE_VALUE, OnSpinViewAngle)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_VIEWANGLE_TOOLBAR, OnUpdateSpinViewAngleToolbar)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_EYESEP_VALUE, OnSpinEyeSep)
	ON_UPDATE_COMMAND_UI(IDC_SPIN_EYESEP_TOOLBAR, OnUpdateSpinEyeSepToolbar)
	ON_COMMAND_RANGE(ID_VIEW_DISPLAYMODE_FLATVIEW, ID_VIEW_DISPLAYMODE_ANALGLYPHVIEW, SetDisplayMode)
	ON_UPDATE_COMMAND_UI_RANGE(ID_VIEW_DISPLAYMODE_FLATVIEW, ID_VIEW_DISPLAYMODE_ANALGLYPHVIEW, UpdateDisplayModeMenu)
	ON_COMMAND_RANGE(ID_BUTTON_NO3D, ID_BUTTON_ANAGLYPH, SetDisplayMode)
	ON_UPDATE_COMMAND_UI_RANGE(ID_BUTTON_NO3D, ID_BUTTON_ANAGLYPH, UpdateDisplayModeButton)
	ON_COMMAND_RANGE(ID_VIEW_SHOWSPECTRALCLASS_CLASSO, ID_VIEW_SHOWSPECTRALCLASS_CLASSX, ShowSpectralClass)
	ON_UPDATE_COMMAND_UI_RANGE(ID_VIEW_SHOWSPECTRALCLASS_CLASSO, ID_VIEW_SHOWSPECTRALCLASS_CLASSX, UpdateSpectralClass)
	ON_COMMAND_RANGE(ID_COLOR_SETSPECTRALCOLORS_CLASSO, ID_COLOR_SETSPECTRALCOLORS_CLASSX, SetSpectralColor)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStereoStarView construction/destruction

/***************************************************************************/
CStereoStarView::CStereoStarView() : offscreenBitMap(NULL), offscreenDCInit(FALSE), theMainFrame(NULL)
{
	CString				fontTypeName;
	int					fontPoints;

	offscreenDCInit = FALSE;
	pOldOffscreenBmp = NULL;

	ChangeScreenDimensions(640, 480);

	viewMode = theApp.GetProfileInt("Settings", VIEW_MODE_KEY, NO3D);
	scaleFactor[SCALE_3D] = 100.0;
	scaleFactor[SCALE_NO_3D] = 100.0;
	if (NO3D == viewMode)	scaleMode = SCALE_NO_3D;
	else					scaleMode = SCALE_3D;

	perspectiveEngine = new CPerspectiveEngine(270.0, 0.0, 6.0);
	perspectiveEngine->setViewAngle(45.0);

	lineLimit			= (theApp.GetProfileInt("Settings", LINE_LIMIT_KEY, 20)) / 10.0;
	showLine[LIMIT_LINE]= theApp.GetProfileInt("Settings", SHOW_LINE_LIMIT_KEY,		FALSE);
	showLine[CLOSEST_LINE]= theApp.GetProfileInt("Settings", SHOW_LINE_CLOSEST_KEY,	FALSE);
	showLine[CUSTOM_LINE]= theApp.GetProfileInt("Settings", SHOW_CUSTOM_LINES_KEY,	FALSE);
	showLines			= theApp.GetProfileInt("Settings", SHOW_LINES_KEY,			TRUE);
	showLineAlt[XY]		= theApp.GetProfileInt("Settings", SHOW_LINE_ALT_XY_KEY,	FALSE);
	showLineAlt[XZ]		= theApp.GetProfileInt("Settings", SHOW_LINE_ALT_XZ_KEY,	FALSE);
	showLineAlt[YZ]		= theApp.GetProfileInt("Settings", SHOW_LINE_ALT_YZ_KEY,	FALSE);
	coordType			= theApp.GetProfileInt("Settings", COORD_TYPE_KEY,			EQUITORIAL);
	showCoords			= theApp.GetProfileInt("Settings", SHOW_COORDS_KEY,			FALSE);
	showDecimalCoord	= theApp.GetProfileInt("Settings", SHOW_DECIMAL_COORD_KEY,	FALSE);
	showNames			= theApp.GetProfileInt("Settings", SHOW_NAMES_KEY,			TRUE);
	showBitmapStars		= theApp.GetProfileInt("Settings", SHOW_BITMAP_STARS_KEY,	TRUE);
	showLineShadow		= theApp.GetProfileInt("Settings", SHOW_LINE_SHADOW_KEY,	FALSE);
	showPlane[XY]		= theApp.GetProfileInt("Settings", SHOW_XY_PLANE_KEY,		TRUE);
	showPlane[XZ]		= theApp.GetProfileInt("Settings", SHOW_XZ_PLANE_KEY,		FALSE);
	showPlane[YZ]		= theApp.GetProfileInt("Settings", SHOW_YZ_PLANE_KEY,		FALSE);
	showRadials			= theApp.GetProfileInt("Settings", SHOW_RADIALS_KEY,		FALSE);
	showXYZAxis			= theApp.GetProfileInt("Settings", SHOW_XYZ_AXIS_KEY,		TRUE);
	labelLineLength		= theApp.GetProfileInt("Settings", LABEL_LINE_LENGTH_KEY,	FALSE);

	distanceFilter		= theApp.GetProfileInt("Settings", DISTANCE_FILTER_KEY,		FALSE);
	distanceFilterLimit = 100.0;
	distanceFilterLimit	= (theApp.GetProfileInt("Settings", DISTANCE_FILTER_LIMIT_KEY, 1000)) / 10.0;

	starImage[CLASS_O].LoadBitmap(IDB_STAR_O);
	starImage[CLASS_B].LoadBitmap(IDB_STAR_B);
	starImage[CLASS_A].LoadBitmap(IDB_STAR_A);
	starImage[CLASS_F].LoadBitmap(IDB_STAR_F);
	starImage[CLASS_G].LoadBitmap(IDB_STAR_G);
	starImage[CLASS_K].LoadBitmap(IDB_STAR_K);
	starImage[CLASS_M].LoadBitmap(IDB_STAR_M);
	starImage[CLASS_X].LoadBitmap(IDB_STAR_X);

	classOBitmap.LoadBitmap(IDB_STAR_O);
	classBBitmap.LoadBitmap(IDB_STAR_B);
	classABitmap.LoadBitmap(IDB_STAR_A);
	classFBitmap.LoadBitmap(IDB_STAR_F);
	classGBitmap.LoadBitmap(IDB_STAR_G);
	classKBitmap.LoadBitmap(IDB_STAR_K);
	classMBitmap.LoadBitmap(IDB_STAR_M);
	classXBitmap.LoadBitmap(IDB_STAR_X);

	showClass[CLASS_O]	= theApp.GetProfileInt("Settings", SHOW_CLASS_O_KEY,		TRUE);
	showClass[CLASS_B]	= theApp.GetProfileInt("Settings", SHOW_CLASS_B_KEY,		TRUE);
	showClass[CLASS_A]	= theApp.GetProfileInt("Settings", SHOW_CLASS_A_KEY,		TRUE);
	showClass[CLASS_F]	= theApp.GetProfileInt("Settings", SHOW_CLASS_F_KEY,		TRUE);
	showClass[CLASS_G]	= theApp.GetProfileInt("Settings", SHOW_CLASS_G_KEY,		TRUE);
	showClass[CLASS_K]	= theApp.GetProfileInt("Settings", SHOW_CLASS_K_KEY,		TRUE);
	showClass[CLASS_M]	= theApp.GetProfileInt("Settings", SHOW_CLASS_M_KEY,		TRUE);
	showClass[CLASS_X]	= theApp.GetProfileInt("Settings", SHOW_CLASS_X_KEY,		TRUE);

	spectralColor[CLASS_O]	= ReadColorFromRegister(O_COLOR_KEY, O_DEFAULT_COLOR);
	spectralColor[CLASS_B]	= ReadColorFromRegister(B_COLOR_KEY, B_DEFAULT_COLOR);
	spectralColor[CLASS_A]	= ReadColorFromRegister(A_COLOR_KEY, A_DEFAULT_COLOR);
	spectralColor[CLASS_F]	= ReadColorFromRegister(F_COLOR_KEY, F_DEFAULT_COLOR);
	spectralColor[CLASS_G]	= ReadColorFromRegister(G_COLOR_KEY, G_DEFAULT_COLOR);
	spectralColor[CLASS_K]	= ReadColorFromRegister(K_COLOR_KEY, K_DEFAULT_COLOR);
	spectralColor[CLASS_M]	= ReadColorFromRegister(M_COLOR_KEY, M_DEFAULT_COLOR);
	spectralColor[CLASS_X]	= ReadColorFromRegister(X_COLOR_KEY, X_DEFAULT_COLOR);

	currentLineColor		= ReadColorFromRegister(LINE_COLOR_KEY,		LINE_DEFAULT_COLOR);
	currentAltLineColor		= ReadColorFromRegister(ALT_COLOR_KEY,		ALT_DEFAULT_COLOR);
	currentPlaneColor[XY]	= ReadColorFromRegister(PLANE_XY_COLOR_KEY,	PLANE_XY_DEFAULT_COLOR);
	currentPlaneColor[XZ]	= ReadColorFromRegister(PLANE_XZ_COLOR_KEY,	PLANE_XZ_DEFAULT_COLOR);
	currentPlaneColor[YZ]	= ReadColorFromRegister(PLANE_YZ_COLOR_KEY,	PLANE_YZ_DEFAULT_COLOR);
	currentNameColor		= ReadColorFromRegister(NAME_COLOR_KEY,		NAME_DEFAULT_COLOR);
	currentCoordColor		= ReadColorFromRegister(COORD_COLOR_KEY,	COORD_DEFAULT_COLOR);
	currentBackgroundColor	= ReadColorFromRegister(BG_COLOR_KEY,		BG_DEFAULT_COLOR);
	currentAxisColor		= ReadColorFromRegister(AXIS_COLOR_KEY,		AXIS_DEFAULT_COLOR);

	anaglyphColor[LEFT] = CYANCOLOR;
	anaglyphColor[RIGHT] = REDCOLOR;

	nameFont = new(CFont);
	coordFont = new(CFont);

	fontTypeName = theApp.GetProfileString("Settings", NAME_FONT_TYPEFACE_KEY,	"arial");
	fontPoints	 = theApp.GetProfileInt(   "Settings", NAME_FONT_POINT_KEY,		8);
	nameFont->CreatePointFont(fontPoints * 10, fontTypeName);

	fontTypeName = theApp.GetProfileString("Settings", COORD_FONT_TYPEFACE_KEY,	"arial");
	fontPoints	 = theApp.GetProfileInt(   "Settings", COORD_FONT_POINT_KEY,	8);
	coordFont->CreatePointFont(fontPoints * 10, fontTypeName);

}
// end CStereoStarView::CStereoStarView

/***************************************************************************/
CStereoStarView::~CStereoStarView()
{
	if (offscreenDCInit)
	{
		offscreenDC.SelectObject(pOldOffscreenBmp);
		offscreenDC.DeleteDC();
		if (offscreenBitMap != NULL)
		{
			delete offscreenBitMap;
			offscreenBitMap = NULL;
		}
	}

	EmptyAllLineLists();
	EmptyEyeLists();

	delete nameFont;
	delete coordFont;
}
// end CStereoStarView::~CStereoStarView

/***************************************************************************/
BOOL CStereoStarView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}
// end CStereoStarView::PreCreateWindow

/////////////////////////////////////////////////////////////////////////////
// CStereoStarView drawing

/***************************************************************************/
void CStereoStarView::OnDraw(CDC* pDC)
{
	// ## this code can be made more efficient by calling GetUpdateRect()
	// and only drawing what appears in that rect
	CStereoStarDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CRect	rc;
	CRect	eraseRect;

	GetClientRect(rc);

	// Do the bit block transfer from our mem DC to the screen DC
	// if bitmap is smaller than screen, center it
	int x=0;
	int y=0;
	int cx,cy;
	BITMAP BitmapInfo;

	offscreenBitMap->GetObject(sizeof(BITMAP), (BITMAP*) &BitmapInfo);
	cx = BitmapInfo.bmWidth;
	cy = BitmapInfo.bmHeight;
	if  (rc.Width() > cx)
		x = (rc.Width() - cx) / 2;
	if  (rc.Height() > cy)
		y = (rc.Height() - cy) / 2;

	// OnPrepareDC has altered the viewpoint origin and the clip region to
	// take care of scrolling, OnDraw doesn't have to worry about it]
	pDC->BitBlt(x, y, cx, cy, &offscreenDC, 0, 0, SRCCOPY);

	// ## this doesn't work if scroll bars are not in neutral and scale is reduced
	if (rc.Width() > cx)
	{
		eraseRect.SetRect(0, 0, x, rc.Height());
		pDC->FillSolidRect(eraseRect, GRAYCOLOR);
		eraseRect.SetRect(x + cx, 0, rc.Width(), rc.Height());
		pDC->FillSolidRect(eraseRect, GRAYCOLOR);
	}
	if (rc.Height() > cy)
	{
		eraseRect.SetRect(0, 0 ,rc.Width(), y);
		pDC->FillSolidRect(eraseRect, GRAYCOLOR);
		eraseRect.SetRect(0, y + cy, rc.Width(), rc.Height());
		pDC->FillSolidRect(eraseRect, GRAYCOLOR);
	}

}
// end CStereoStarView::OnDraw

/////////////////////////////////////////////////////////////////////////////
// CStereoStarView printing

/***************************************************************************/
BOOL CStereoStarView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ## insert length of document into Print Dialog box
	// pInfo->SetMaxPage();

	// default preparation
	return DoPreparePrinting(pInfo);	// display print dialog box and create print device context
}
// end CStereoStarView::OnPreparePrinting

/***************************************************************************/
void CStereoStarView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// set length of document as per pDC, if not set already
	// allocate fonts and other GDI objects needed
	HDC hDC = ::GetDC(NULL);
	BITMAP	BitmapInfo;
	double	intermediate;
	double	bmWidthInches, bmHeightInches;
	double	printWidthInches, printHeightInches;
	short	pagesHigh;

	printHorzRes = pDC->GetDeviceCaps(HORZRES);
	printVertRes = pDC->GetDeviceCaps(VERTRES);
	printWidthInches	= printHorzRes / pDC->GetDeviceCaps(LOGPIXELSX);
	printHeightInches	= printVertRes / pDC->GetDeviceCaps(LOGPIXELSY);

	offscreenBitMap->GetObject(sizeof(BITMAP), (BITMAP*) &BitmapInfo);
	if (hDC)
	{
		bmWidthInches	= BitmapInfo.bmWidth  / ::GetDeviceCaps(hDC,LOGPIXELSX);
		bmHeightInches	= BitmapInfo.bmHeight / ::GetDeviceCaps(hDC,LOGPIXELSY);
	}
	else
	{
		bmWidthInches	= BitmapInfo.bmWidth  / 96;	// 96 ppi for computer monitors
		bmHeightInches	= BitmapInfo.bmHeight / 96;
	}


	intermediate = bmWidthInches / printWidthInches;
	pagesWide = ceil(intermediate);
	intermediate = bmHeightInches / printHeightInches;
	pagesHigh = ceil(intermediate);

	pInfo->SetMaxPage(pagesWide * pagesHigh);

	// TODO: add extra initialization before printing
}
// end CStereoStarView::OnBeginPrinting

/***************************************************************************/
void CStereoStarView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing

	// ## deallocate any GDI objects allocated in OnBeginPrinting
}
// end CStereoStarView::OnEndPrinting

/////////////////////////////////////////////////////////////////////////////
// CStereoStarView diagnostics

#ifdef _DEBUG

/***************************************************************************/
void CStereoStarView::AssertValid() const
{
	CScrollView::AssertValid();
}
// end CStereoStarView::AssertValid

/***************************************************************************/
void CStereoStarView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
// end CStereoStarView::Dump

/***************************************************************************/
CStereoStarDoc* CStereoStarView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CStereoStarDoc)));
	return (CStereoStarDoc*)m_pDocument;
}
// end CStereoStarView::GetDocument
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CStereoStarView message handlers


/***************************************************************************/
// Transform all the screen objects from xyz into persepective screen x,y
/***************************************************************************/
void CStereoStarView::Calc3D(short eyeID)
{
	short		a, b;
	DuoPoint*	thePoint;
	TriPoint	theLoc;
	double		ex,ey;
	CProgressDialog	dlg;

	perspectiveEngine->initEye(eyeID);

	// Transform all the star locations
	int numStars = theDoc->GetNumStars();
	if (NO3D == viewMode)
	{
		dlg.Create(IDD_PROGRESS_DIALOG, NULL);
		dlg.UserInit(numStars, "Calc3D Star #");
	}

	for (a = 0; a < numStars; a++)
	{
		if (NO3D == viewMode)
			dlg.StepIt();
		theLoc = theDoc->GetLoc(a, coordType);
		perspectiveEngine->transformPoint(&theLoc, &ex, &ey);
		thePoint = new(DuoPoint);
		thePoint->x = ex;
		thePoint->y = ey;
		theEye[eyeID].AddTail(thePoint);

		theLoc.z = perspectiveEngine->origin.z;
		perspectiveEngine->transformPoint(&theLoc, &ex, &ey);
		thePoint = new(DuoPoint);
		thePoint->x = ex;
		thePoint->y = ey;
		altitude[eyeID].AddTail(thePoint);
	}
	// Transform the origin (used for radial lines)

	dlg.DestroyWindow();

	theLoc.x = perspectiveEngine->origin.x;
	theLoc.y = perspectiveEngine->origin.y;
	theLoc.z = perspectiveEngine->origin.z;

	perspectiveEngine->transformPoint(&theLoc, &ex, &ey);
	planeCenter[eyeID].x = ex;
	planeCenter[eyeID].y = ey;


	// Transform the cartesian axises
	for (a = 0; a < NUMAXIS; a++)
	{
		for (int b = 0; b < NUMSIGN; b++)
		{
			theLoc = axisCoords[a][b][coordType];
			perspectiveEngine->transformPoint(&theLoc, &ex, &ey);
			axis[a][b][eyeID].x = ex;
			axis[a][b][eyeID].y = ey;
		}
	}

	// transform the planes
	for (a = 0; a < NUMPLANES; a++)
	{
		for (b = 0; b < NUMCORNERS; b++)
		{
			theLoc = theDoc->plane[a][b][coordType];
			if (theLoc.x == 0.0)	
				theLoc.x += perspectiveEngine->origin.x;
			if (theLoc.y == 0.0)	
				theLoc.y += perspectiveEngine->origin.y;
			if (theLoc.z == 0.0)	
				theLoc.z += perspectiveEngine->origin.z;
			perspectiveEngine->transformPoint(&theLoc, &ex, &ey);
			plane[a][b][eyeID].x = ex;
			plane[a][b][eyeID].y = ey;
		}
	}

}
// end CStereoStarView::Calc3D

/***************************************************************************/
// Transform all the screen objects, first for left eye, then for right
/***************************************************************************/
void CStereoStarView::CalcEye()
{
	EmptyEyeLists();
	EmptyAltLists();

	Calc3D(LEFT);
	Calc3D(RIGHT);
}
// end CStereoStarView::CalcEye

/***************************************************************************/
// Generate a list of lines connecting each star with all other stars
// closer than the user set limit
/***************************************************************************/
void CStereoStarView::LineLimit()
{
	short			a,b,bmax;
	TriPoint		pointA;
	TriPoint		pointB;
	double			dist;
	CStarLine*		theStarLine;
	CProgressDialog	dlg;
	int				numStars = theDoc->GetNumStars();

	EmptyLineList(LIMIT_LINE);

	dlg.Create(IDD_PROGRESS_DIALOG, NULL);
	dlg.UserInit(numStars, "LineLimit Star #");

	bmax = -1;
	for (a = 1; a < numStars; a++) {
		dlg.StepIt();
		bmax++;

		if (StarVisible(a)) {
			pointA = theDoc->GetLoc(a, coordType);

			for (b = 0; b <= bmax; b++) {
				if (StarVisible(b)) {
					pointB = theDoc->GetLoc(b, coordType);
					if ((abs(pointA.x - pointB.x) <= lineLimit) &&
						(abs(pointA.y - pointB.y) <= lineLimit) &&
						(abs(pointA.z - pointB.z) <= lineLimit)) {
						dist = TrueDistance(&pointA, &pointB);
						if (dist <= lineLimit) {
							theStarLine = new CStarLine(a, b, dist);
							lines[LIMIT_LINE].AddTail(theStarLine);
						}
					}
				}
			}
		}
	}

	dlg.DestroyWindow();

}
// end CStereoStarView::LineLimit

/***************************************************************************/
// generate a list of lines connecting each star with it's closest neighbor
/***************************************************************************/
void CStereoStarView::LineClosest()
{
	short		a,b;
	TriPoint	pointA;
	TriPoint	pointB;
	double		dist, currDist;
	short		neighbor;
	CStarLine*	theStarLine;
	CProgressDialog	dlg;
	
	EmptyLineList(CLOSEST_LINE);

	int numStars = theDoc->GetNumStars();
	dlg.Create(IDD_PROGRESS_DIALOG, NULL);
	dlg.UserInit(numStars, "LineClosest Star #");

	for (a = 0; a < numStars; a++) {
		dlg.StepIt();
		if (StarVisible(a)) {
			pointA = theDoc->GetLoc(a, coordType);
			currDist = 9999999.0;
			neighbor = -1;
			// do not do (b=0;b<a;b++)
			// Just because bravo is the closest star to albert it doesn't
			// necessarily mean that albert is the closest star to bravo.
			for (b = 0; b < numStars; b++) {
				if (StarVisible(b)) {
					if (b != a) {
						pointB = theDoc->GetLoc(b, coordType);

						if ((abs(pointA.x - pointB.x) <= currDist) &&
							(abs(pointA.y - pointB.y) <= currDist) &&
							(abs(pointA.z - pointB.z) <= currDist)) {
							dist = TrueDistance(&pointA, &pointB);
							if (dist <= currDist) {
								currDist = dist;
								neighbor = b;
							}
						}
					}
				}
			}
			if (neighbor != -1)
			{
				theStarLine = new CStarLine(a, neighbor, currDist);
				lines[CLOSEST_LINE].AddTail(theStarLine);
			}
		}
	}

	dlg.DestroyWindow();
}
// end CStereoStarView::LineClosest


/***************************************************************************/
// Load the line list with the various specified lines
/***************************************************************************/
void CStereoStarView::CalcLine()
{
	if (showLine[CLOSEST_LINE])
		LineClosest();

	if (showLine[LIMIT_LINE])
		LineLimit();
}
// end CStereoStarView::CalcLine

/***************************************************************************/
void CStereoStarView::InitializeLine()
{
	LineClosest();
	LineLimit();
}
// end CStereoStarView::CalcLine

/***************************************************************************/
// Calculate the distance between pointA and pointB
/***************************************************************************/
double CStereoStarView::TrueDistance(TriPoint *pointA, TriPoint *pointB)
{
	double	delta_x, delta_y, delta_z;

	delta_x = pointA->x - pointB->x;
	delta_y = pointA->y - pointB->y;
	delta_z = pointA->z - pointB->z;
#ifdef OLD
	return pow(10.0, (log10((delta_x * delta_x) + (delta_y * delta_y) + (delta_z * delta_z)) / 2.0));
#else
	return sqrt((delta_x * delta_x) + (delta_y * delta_y) + (delta_z * delta_z));
#endif
}
// end CStereoStarView::TrueDistance

/***************************************************************************/
// Calculate the squared distance between pointA and pointB
// When compairing large numbers of distances, use the squared distance
// to avoid the computational time cost of using sqrt()
/***************************************************************************/
double CStereoStarView::SquareDistance(TriPoint *pointA, TriPoint *pointB)
{
	double	delta_x, delta_y, delta_z;

	delta_x = pointA->x - pointB->x;
	delta_y = pointA->y - pointB->y;
	delta_z = pointA->z - pointB->z;
	return (delta_x * delta_x) + (delta_y * delta_y) + (delta_z * delta_z);
}
// end CStereoStarView::SquareDistance


/***************************************************************************/
// convert degrees to radians
/***************************************************************************/
double CStereoStarView::MakeRadians(double degrees)
{
	return degrees * 0.017453293;
}
// end CStereoStarView::MakeRadians

/***************************************************************************/
void CStereoStarView::DrawStar(CPaintDC* dc, short starNum, double plotX, double plotY, COLORREF theColor)
{
	CPen*		oldPen;
	CBitmap    *pOldBmp;
	CDC			memDC;
	BITMAP		bm;
	long		bmWidth, bmHeight;
	int			plotXI = plotX;
	int			plotYI = plotY;
	short		spectralClass = theDoc->GetSpectralClass(starNum);
	CBitmap		tempCBitmap;
	CRgn		theNewStarRgn;

	if ((theColor == WHITECOLOR) && (!showBitmapStars)) {
		theColor = spectralColor[spectralClass];
	}


	CPen	thePen(PS_SOLID,0, theColor);
	if (theColor != WHITECOLOR) {
		oldPen = (CPen*)dc->SelectObject(&thePen);
		dc->MoveTo(plotXI, plotYI-5);
		dc->LineTo(plotXI, plotYI+6);
		dc->MoveTo(plotXI-5, plotYI);
		dc->LineTo(plotXI+6, plotYI);
		dc->Arc(plotXI-3,plotYI+4, plotXI+4, plotYI-3, plotXI+4, plotYI+4, plotXI+4, plotYI+4);
		dc->SelectObject(oldPen);
	}
	else {
		if(!memDC.CreateCompatibleDC(dc))
			return;
		pOldBmp = (CBitmap*)memDC.SelectObject(starImage[ spectralClass ]);
		if(starImage[ spectralClass ].GetObject(sizeof(BITMAP), &bm) == 0) {
			bmWidth = 0;
			bmHeight = 0;
		}
		else {
			bmWidth = bm.bmWidth;
			bmHeight = bm.bmHeight;
		}
#ifdef OLD
		dc->BitBlt( plotXI-7, plotYI-7, bmWidth, bmHeight, &memDC, 0,0, SRCCOPY);
#else
		switch(spectralClass)
		{
		case CLASS_O:	TransparentBlt(dc->m_hDC, plotXI-7, plotYI-7, bmWidth, bmHeight, classOBitmap, 0,0, TRANSPARENTCOLOR, NULL);	break;
		case CLASS_B:	TransparentBlt(dc->m_hDC, plotXI-7, plotYI-7, bmWidth, bmHeight, classBBitmap, 0,0, TRANSPARENTCOLOR, NULL);	break;
		case CLASS_A:	TransparentBlt(dc->m_hDC, plotXI-7, plotYI-7, bmWidth, bmHeight, classABitmap, 0,0, TRANSPARENTCOLOR, NULL);	break;
		case CLASS_F:	TransparentBlt(dc->m_hDC, plotXI-7, plotYI-7, bmWidth, bmHeight, classFBitmap, 0,0, TRANSPARENTCOLOR, NULL);	break;
		case CLASS_G:	TransparentBlt(dc->m_hDC, plotXI-7, plotYI-7, bmWidth, bmHeight, classGBitmap, 0,0, TRANSPARENTCOLOR, NULL);	break;
		case CLASS_K:	TransparentBlt(dc->m_hDC, plotXI-7, plotYI-7, bmWidth, bmHeight, classKBitmap, 0,0, TRANSPARENTCOLOR, NULL);	break;
		case CLASS_M:	TransparentBlt(dc->m_hDC, plotXI-7, plotYI-7, bmWidth, bmHeight, classMBitmap, 0,0, TRANSPARENTCOLOR, NULL);	break;
		case CLASS_X:	TransparentBlt(dc->m_hDC, plotXI-7, plotYI-7, bmWidth, bmHeight, classXBitmap, 0,0, TRANSPARENTCOLOR, NULL);	break;
		}
#endif
		memDC.DeleteDC();
	}
}
// end CStereoStarView::DrawStar

/***************************************************************************/
void CStereoStarView::DrawLine(CPaintDC* dc, double startX, double startY, double endX, double endY, COLORREF theColor)
{
	CPen		thePen(PS_SOLID,0, theColor);
	CPen*		oldPen;
	short		startXI = startX;
	short		startYI = startY;
	short		endXI = endX;
	short		endYI = endY;

	oldPen = (CPen*)dc->SelectObject(&thePen);
	dc->MoveTo(startXI, startYI);
	dc->LineTo(endXI, endYI);
	dc->SelectObject(oldPen);
}
// end CStereoStarView::DrawLine

/***************************************************************************/
// ## instead of passing starnum, why not pass a StarNode* theNode ?
void CStereoStarView::DrawName(CPaintDC* dc, short starNum, double plotX, double plotY, COLORREF theNameColor, COLORREF theCoordColor)
{
	char		buffer[80];
	CString		theName;
	CString		theCoords;
	TriPoint	theLoc;
	short		plotXI = (short)plotX;
	short		plotYI = (short)plotY;
	CFont*		oldFont;
	UINT		oldAlign;
//	CPoint		textDrawPoint;
	CPoint	theTextPoint;
	RECT		textDrawRect;
	CSize		nameDrawSize(0,0);
	CSize		coordDrawSize(0,0);
	CSize		maxTextDrawSize;
	CPen		thePen(PS_SOLID,0, currentAltLineColor);
	CPen*		oldPen;
	int			justification;

	theLoc = theDoc->GetLoc(starNum, coordType);
	theName = theDoc->GetStarName(starNum);
	theName.TrimRight();
	if (showDecimalCoord)
		theCoords.Format("%3.1f:%3.1f:%3.1f", theLoc.x, theLoc.y, theLoc.z);
	else
		theCoords.Format("%.0f:%.0f:%.0f", theLoc.x, theLoc.y, theLoc.z);
	theCoords.TrimRight();
	if (viewMode != NO3D)
	{
		oldFont = dc->SelectObject(nameFont);
		if (showNames)
			nameDrawSize = dc->GetTextExtent(theName);
		dc->SelectObject(coordFont);
		if (showCoords)
			coordDrawSize = dc->GetTextExtent(theCoords);
		maxTextDrawSize.cx = (nameDrawSize.cx > coordDrawSize.cx) ? nameDrawSize.cx : coordDrawSize.cx;
		maxTextDrawSize.cy = nameDrawSize.cy + coordDrawSize.cy;
		theTextPoint.x = plotXI + 7;
		theTextPoint.y = plotYI - maxTextDrawSize.cy;
		textDrawRect.left = theTextPoint.x;
		textDrawRect.top = theTextPoint.y;
		textDrawRect.right = theTextPoint.x + maxTextDrawSize.cx;
		textDrawRect.bottom = theTextPoint.y + maxTextDrawSize.cy;
		justification = DT_LEFT;
	}
	else
		theDoc->GetNameRect(starNum, &textDrawRect, &justification);

#ifdef OLD
	// draw line from star name to star
	if (viewMode == NO3D) {
		oldPen = (CPen*)dc->SelectObject(&thePen);
		dc->MoveTo(textDrawRect.left, textDrawRect.top);
		dc->LineTo(plotX, plotY);
		dc->SelectObject(oldPen);
	}
#endif

	// Draw Name
	dc->SelectObject(nameFont);
	dc->SetBkMode(TRANSPARENT);
	if (showNames) {
		dc->SetTextColor(theNameColor);
		dc->DrawText(theName, &textDrawRect, DT_SINGLELINE | DT_TOP | justification);
	}

	// Draw co-ords
	dc->SelectObject(coordFont);
	if (showCoords) {
		dc->SetTextColor(theCoordColor);
		dc->DrawText(theCoords, &textDrawRect, DT_SINGLELINE | DT_BOTTOM | justification);
	}

	dc->SetTextColor(BLACKCOLOR);
	dc->SelectObject(oldFont);

}
// end CStereoStarView::DrawName

/***************************************************************************/
void CStereoStarView::InitializeNameRects()
{
	CDC*		dc = GetDC();
	double		plotX,plotY;
	TriPoint	theLoc;
	int			numStars = theDoc->GetNumStars();
	int			plotXI;
	int			plotYI;
	int			starNum;
	int			justification;
	CString		theName;
	CString		theCoords;
	CFont*		oldFont;
	CRgn		theNewStarRgn;
	CSize		nameDrawSize(0,0);
	CSize		coordDrawSize(0,0);
	CSize		maxTextDrawSize;
	CRect		textDrawRect;

	textRgnInit = FALSE;
	textRgn.DeleteObject();

	for (starNum = 0; starNum < numStars; starNum++)
	{
		if (StarVisible(starNum))
		{
			theLoc = theDoc->GetLoc(starNum, coordType);
			theLoc.x -= perspectiveEngine->origin.x;
			theLoc.y -= perspectiveEngine->origin.y;
			theLoc.z -= perspectiveEngine->origin.z;
			plotX = ScaleX(theLoc.x);
			plotY = ScaleY(theLoc.y);
			plotXI = plotX;
			plotYI = plotY;

			if (!showBitmapStars) {
				if (FALSE == textRgnInit)
					textRgn.CreateRectRgn(plotXI-5, plotYI-5, plotXI+6, plotYI+6);
				else
					theNewStarRgn.CreateRectRgn(plotXI-5, plotYI-5, plotXI+6, plotYI+6);
			}
			else {
				if (FALSE == textRgnInit)
					textRgn.CreateRectRgn(plotXI-7, plotYI-7, (plotXI-7)+15, (plotYI-7)+15);
				else
					theNewStarRgn.CreateRectRgn(plotXI-7, plotYI-7, (plotXI-7)+15, (plotYI-7)+15);
			}
			if (FALSE == textRgnInit)	
				textRgnInit = TRUE;
			else						
			{
				textRgn.CombineRgn(&textRgn, &theNewStarRgn, RGN_OR);
				theNewStarRgn.DeleteObject();
			}
		}
	}

	oldFont = dc->SelectObject(nameFont);
	for (starNum = 0; starNum < numStars; starNum++)
	{
		if (StarVisible(starNum))
		{
			theLoc = theDoc->GetLoc(starNum, coordType);
			theLoc.x -= perspectiveEngine->origin.x;
			theLoc.y -= perspectiveEngine->origin.y;
			theLoc.z -= perspectiveEngine->origin.z;
			plotX = ScaleX(theLoc.x);
			plotY = ScaleY(theLoc.y);
			plotXI = plotX;
			plotYI = plotY;

			theLoc = theDoc->GetLoc(starNum, coordType);
			theName = theDoc->GetStarName(starNum);
			theName.TrimRight();
			if (showDecimalCoord)
				theCoords.Format("%3.1f:%3.1f:%3.1f", theLoc.x, theLoc.y, theLoc.z);
			else
				theCoords.Format("%.0f:%.0f:%.0f", theLoc.x, theLoc.y, theLoc.z);
			theCoords.TrimRight();
			dc->SelectObject(nameFont);
			if (showNames)
				nameDrawSize = dc->GetTextExtent(theName);
			dc->SelectObject(coordFont);
			if (showCoords)
				coordDrawSize = dc->GetTextExtent(theCoords);
			maxTextDrawSize.cx = (nameDrawSize.cx > coordDrawSize.cx) ? nameDrawSize.cx : coordDrawSize.cx;
			maxTextDrawSize.cy = nameDrawSize.cy + coordDrawSize.cy;
			textDrawRect = GetUnobscuredTextLocation(plotXI, plotYI, maxTextDrawSize, &justification);
			// set justification and name rect
			theDoc->SetNameRect(starNum, (LPRECT)textDrawRect, justification);
		}
	}
	dc->SelectObject(oldFont);

}

/***************************************************************************/
CRect CStereoStarView::GetUnobscuredTextLocation(int centerX, int centerY, CSize textSize, int* justification)
{
	CRect	theTextRect;
	CPoint	theTextPoint;
	CRgn	theNewTextRgn;

	*justification = DT_LEFT;
	if ((FALSE == textRgnInit) || (viewMode != NO3D))
	{
		theTextPoint.x = centerX + 7;
		theTextPoint.y = centerY - textSize.cy;
		theTextRect.SetRect(theTextPoint.x, theTextPoint.y, 
							theTextPoint.x + textSize.cx, theTextPoint.y + textSize.cy);
		if (viewMode == NO3D)
		{
			textRgnInit = TRUE;
			textRgn.CreateRectRgnIndirect(theTextRect);
		}
	}
	else
	{
		for (int i = 0; i < 8; i++)
		{
			switch(i) {
			case 0:	
				theTextPoint.x = centerX + 7;
				theTextPoint.y = centerY - textSize.cy;
				*justification = DT_LEFT;
				break;
			case 1:	
				theTextPoint.x = centerX + 10;
				theTextPoint.y = centerY - (textSize.cy / 2) ;
				*justification = DT_LEFT;
				break;
			case 2:	
				theTextPoint.x = centerX + 7;
				theTextPoint.y = centerY;
				*justification = DT_LEFT;
				break;
			case 3:	
				theTextPoint.x = centerX - (textSize.cx / 2);
				theTextPoint.y = centerY + 10;
				*justification = DT_CENTER;
				break;
			case 4:	
				theTextPoint.x = centerX - (7 + textSize.cx);
				theTextPoint.y = centerY;
				*justification = DT_RIGHT;
				break;
			case 5:	
				theTextPoint.x = centerX - (10 + textSize.cx);
				theTextPoint.y = centerY - (textSize.cy / 2);
				*justification = DT_RIGHT;
				break;
			case 6:	
				theTextPoint.x = centerX - (7 + textSize.cx);
				theTextPoint.y = centerY - textSize.cy;
				*justification = DT_RIGHT;
				break;
			case 7:	
				theTextPoint.x = centerX - (textSize.cx / 2);
				theTextPoint.y = centerY - (textSize.cy + 7);
				*justification = DT_CENTER;
				break;
			}
			theTextRect.SetRect(theTextPoint.x, theTextPoint.y, 
								theTextPoint.x + textSize.cx, theTextPoint.y + textSize.cy);
			if (!textRgn.RectInRegion(theTextRect))
				break;
		}
		theNewTextRgn.CreateRectRgnIndirect(theTextRect);
		textRgn.CombineRgn(&textRgn, &theNewTextRgn, RGN_OR);
	}

	return theTextRect;
}

// end CStereoStarView::GetUnobscuredTextLocation

/***************************************************************************/
double CStereoStarView::ScaleX(double locX, int eyeID)
{
	return (locX * scaleFactor[scaleMode]) + scx[eyeID][viewMode];
}

/***************************************************************************/
double CStereoStarView::ScaleY(double locY)
{
	return SY - ((locY * scaleFactor[scaleMode]) + SCY);
}

/***************************************************************************/
void CStereoStarView::PlotStar(CPaintDC* dc)
{
	double		plotX,plotY;
	CRgn		theClip;
	DuoPoint*	eye;
	int			oldMode;
	COLORREF	starColor, nameColor, coordColor;
	int			maxA;
	TriPoint	theLoc;
	int			numStars = theDoc->GetNumStars();

	if (viewMode == ANAGLYPH)
		oldMode = dc->SetROP2(R2_MASKPEN);

	if (viewMode == NO3D)	maxA = 1;
	else					maxA = NUMEYES;
	for (int a = 0; a < maxA; a++)
	{
		if ((viewMode == WIDEEYE) || (viewMode == CROSSEYE)) 
		{
			if (a == LEFT) 
			{
				if (viewMode == CROSSEYE)	theClip.CreateRectRgn(SCX, 0, SX, SY);
				else						theClip.CreateRectRgn(0, 0, SCX, SY);
			}
			else 
			{
				if (viewMode == CROSSEYE)	theClip.CreateRectRgn(0, 0, SCX, SY);
				else						theClip.CreateRectRgn(SCX, 0, SX, SY);
			}
			dc->SelectClipRgn(&theClip);
			theClip.DeleteObject();
		}

		for (int starNum = 0; starNum < numStars; starNum++)
		{
			if (StarVisible(starNum))
			{
				if (viewMode == NO3D) 
				{
					theLoc = theDoc->GetLoc(starNum, coordType);
					theLoc.x -= perspectiveEngine->origin.x;
					theLoc.y -= perspectiveEngine->origin.y;
					theLoc.z -= perspectiveEngine->origin.z;
					plotX = ScaleX(theLoc.x);
					plotY = ScaleY(theLoc.y);
				}
				else 
				{
					eye = (DuoPoint*)theEye[a].GetAt(theEye[a].FindIndex(starNum));
					plotX = ScaleX(eye->x, a);
					plotY = ScaleY(eye->y);
				}
				starColor = WHITECOLOR;
				nameColor = currentNameColor;
				coordColor = currentCoordColor;
				if (viewMode == ANAGLYPH) 
				{
					starColor = anaglyphColor[a];
					nameColor = anaglyphColor[a];
					coordColor = anaglyphColor[a];
				}
				DrawStar(dc, starNum, plotX, plotY, starColor);
				if (viewMode != NO3D) 
					DrawName(dc, starNum, plotX, plotY, nameColor, coordColor);
			}
		}

		if (viewMode == NO3D) 
		{
			for (starNum = 0; starNum < numStars; starNum++)
			{
				if (StarVisible(starNum))
				{
					theLoc = theDoc->GetLoc(starNum, coordType);
					theLoc.x -= perspectiveEngine->origin.x;
					theLoc.y -= perspectiveEngine->origin.y;
					theLoc.z -= perspectiveEngine->origin.z;
					plotX = ScaleX(theLoc.x);
					plotY = ScaleY(theLoc.y);
					DrawName(dc, starNum, plotX, plotY, currentNameColor, currentCoordColor);
				}
			}
		}
	}

	if ((viewMode == WIDEEYE) || (viewMode == CROSSEYE)) 
	{
		theClip.CreateRectRgn(0, 0, SX, SY);
		dc->SelectClipRgn(&theClip);
		theClip.DeleteObject();
	}

	if (viewMode == ANAGLYPH)
		dc->SetROP2(oldMode);
}

/***************************************************************************/
// Draw on the screen all the lines currently in the lines array
/***************************************************************************/
void CStereoStarView::PlotLine(CPaintDC* dc)
{
	CRgn		theClip;
	int			oldMode;
	CStarLine*	theStarLine;
	long		startStar, endStar;
	DuoPoint*	startEye;
	DuoPoint*	endEye;
	COLORREF	lineColor;
	int			maxA;
	TriPoint	startLoc, endLoc;
	CFont*		oldFont;
	UINT		oldAlign;
	COLORREF	oldBkColor;
	char		buffer[10];

	oldFont = dc->SelectObject(coordFont);
	oldAlign = dc->SetTextAlign(TA_CENTER | TA_BASELINE);
	dc->SetBkMode(OPAQUE);
	if (viewMode == ANAGLYPH)	oldBkColor = dc->SetBkColor(WHITECOLOR);
	else						oldBkColor = dc->SetBkColor(currentBackgroundColor);

	if (viewMode == ANAGLYPH)
		oldMode = dc->SetROP2(R2_MASKPEN);

	if (viewMode == NO3D)	maxA = 1;
	else					maxA = NUMEYES;
	for (int a = 0; a < maxA; a++)
	{
		if ((viewMode == WIDEEYE) || (viewMode == CROSSEYE)) {
			if (a == LEFT) {
				if (viewMode == CROSSEYE)	theClip.CreateRectRgn(SCX, 0, SX, SY);
				else						theClip.CreateRectRgn(0, 0, SCX, SY);
			}
			else {
				if (viewMode == CROSSEYE)	theClip.CreateRectRgn(0, 0, SCX, SY);
				else						theClip.CreateRectRgn(SCX, 0, SX, SY);
			}
			dc->SelectClipRgn(&theClip);
			theClip.DeleteObject();
		}
		for (int lineType = 0; lineType < NUM_LINE_TYPES; lineType++)
		{
			if (showLine[lineType])
			{
				int			numLines = lines[lineType].GetCount();
				for (int lineNum = 0; lineNum < numLines; lineNum++)
				{
					theStarLine = (CStarLine*)lines[lineType].GetAt(lines[lineType].FindIndex(lineNum));
					startStar = theStarLine->m_lStartStar;
					endStar   = theStarLine->m_lEndStar;

					lineColor = currentLineColor;
					if (viewMode == ANAGLYPH)
						lineColor = anaglyphColor[a];
					dc->SetTextColor(lineColor);

					if (viewMode == NO3D) {
						startLoc	= theDoc->GetLoc(theStarLine->m_lStartStar, coordType);
						endLoc		= theDoc->GetLoc(theStarLine->m_lEndStar, coordType);
						startLoc.x -= perspectiveEngine->origin.x;
						startLoc.y -= perspectiveEngine->origin.y;
						endLoc.x -= perspectiveEngine->origin.x;
						endLoc.y -= perspectiveEngine->origin.y;
						DrawLine(dc, ScaleX(startLoc.x), ScaleY(startLoc.y), ScaleX(endLoc.x), ScaleY(endLoc.y), lineColor);
						if (labelLineLength)
						{
							sprintf(buffer,"%3.1f", theStarLine->m_dDistance);
							dc->TextOut(ScaleX((startLoc.x + endLoc.x)/2), ScaleY((startLoc.y + endLoc.y)/2), 
								buffer, lstrlen(buffer));
						}
					}
					else {
						startEye = (DuoPoint*)theEye[a].GetAt(theEye[a].FindIndex(startStar));
						endEye = (DuoPoint*)theEye[a].GetAt(theEye[a].FindIndex(endStar));
						DrawLine(dc, ScaleX(startEye->x,a), ScaleY(startEye->y), ScaleX(endEye->x,a), ScaleY(endEye->y), lineColor);
						if (labelLineLength)
						{
							sprintf(buffer,"%3.1f", theStarLine->m_dDistance);
							dc->TextOut(ScaleX((startEye->x + endEye->x)/2, a), ScaleY((startEye->y + endEye->y)/2), 
								buffer, lstrlen(buffer));
						}
						if (showLineShadow)
						{
							lineColor = currentPlaneColor[XY];
							if (viewMode == ANAGLYPH) 
								lineColor = anaglyphColor[a];
							startEye = (DuoPoint*)altitude[a].GetAt(altitude[a].FindIndex(startStar));
							endEye = (DuoPoint*)altitude[a].GetAt(altitude[a].FindIndex(endStar));
							DrawLine(dc, ScaleX(startEye->x,a), ScaleY(startEye->y), ScaleX(endEye->x,a), ScaleY(endEye->y), lineColor);
						}
					}
				}
			}
		}
	}
	if ((viewMode == WIDEEYE) || (viewMode == CROSSEYE)) {
		theClip.CreateRectRgn(0, 0, SX, SY);
		dc->SelectClipRgn(&theClip);
		theClip.DeleteObject();
	}

	if (viewMode == ANAGLYPH)
		dc->SetROP2(oldMode);

	dc->SetBkColor(oldBkColor);
	dc->SetTextColor(BLACKCOLOR);
	dc->SelectObject(oldFont);
	dc->SetTextAlign(oldAlign);

}

/***************************************************************************/
void CStereoStarView::OnInitialUpdate() 
{

	CView::OnInitialUpdate();

	CDC*	dc = GetDC();

	theMainFrame = (CMainFrame *)GetParent();

	theDoc = GetDocument();
	
	CRect rc;
	GetParent()->GetClientRect(&rc);
	ChangeScreenDimensions(rc.Width(), rc.Height());

	if (!offscreenDCInit)	// if FILE:OPEN is called a second time, don't re-do this
	{						// or CreateCompatibleDC will crash
		if (offscreenDC.CreateCompatibleDC(dc))
		{
			offscreenDCInit = TRUE;
			pOldOffscreenBmp = offscreenDC.GetCurrentBitmap();
		}
		ReleaseDC(dc);

		short	theWidth, theHeight;
		theWidth = rc.Width();
		theHeight =rc.Height();
		if (theWidth == 0)	theWidth = 640;
		if (theHeight == 0) theHeight = 480;

		offscreenBitMap = new CBitmap;
		offscreenBitMap->CreateCompatibleBitmap(dc, theWidth, theHeight);
		offscreenDC.SelectObject(offscreenBitMap);
		offscreenRect.SetRect(0,0,theWidth,theHeight);
	}

	ConfigureScrolling();	

	InitializeNameRects();
	UpdateOffscreenBitmap();

	GetParent()->GetClientRect(&theClientRect);

	GetAxis();
}

/***************************************************************************/
void CStereoStarView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	theDoc = GetDocument();

	GetParent()->GetClientRect(&theClientRect);
	ChangeScreenDimensions(theClientRect.Width(), theClientRect.Height());
	ConfigureScrolling();	

	CalcEye();
}

/***************************************************************************/
void CStereoStarView::OnShowCoords() 
{
	showCoords = !showCoords;
	theApp.WriteProfileInt("Settings", SHOW_COORDS_KEY,	showCoords);
	if (NO3D == viewMode)
		InitializeNameRects();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateShowCoordsMenu(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(showCoords);
}

/***************************************************************************/
void CStereoStarView::OnShowClosestNeighbor() 
{
	showLine[CLOSEST_LINE] = !showLine[CLOSEST_LINE];
	theApp.WriteProfileInt("Settings", SHOW_LINE_CLOSEST_KEY,	showLine[CLOSEST_LINE]);
//	CalcLine();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateClosestNeighborMenu(CCmdUI* pCmdUI) 
{
	if (!showLines)
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showLine[CLOSEST_LINE]);
}

/***************************************************************************/
void CStereoStarView::OnSetTheLimit() 
{
	CSetLineLimitDlog	dlg;

	dlg.m_line_limit = lineLimit;
	if  (dlg.DoModal() == IDOK)
	{
		lineLimit = dlg.m_line_limit;
		theApp.WriteProfileInt("Settings", LINE_LIMIT_KEY,	lineLimit * 10);
		CalcLine();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnShowWithinSetLimit() 
{
	showLine[LIMIT_LINE] = !showLine[LIMIT_LINE];
	theApp.WriteProfileInt("Settings", SHOW_LINE_LIMIT_KEY,	showLine[LIMIT_LINE]);
//	CalcLine();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateWithinSetLimitMenu(CCmdUI* pCmdUI) 
{
	if (!showLines)
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showLine[LIMIT_LINE]);
}

/***************************************************************************/
void CStereoStarView::OnSetEquitorialCoords() 
{
	coordType = EQUITORIAL;	
	theApp.WriteProfileInt("Settings", COORD_TYPE_KEY,	coordType);

	// ## kludge, if possible change this to convert origin from 
	// equitorial to galactic co-ords
	perspectiveEngine->origin.x = 0.0;
	perspectiveEngine->origin.y = 0.0;
	perspectiveEngine->origin.z = 0.0;
	distanceFilter = FALSE;
	theApp.WriteProfileInt("Settings", DISTANCE_FILTER_KEY,	distanceFilter);

	ConfigureScrolling();	
	CalcEye();
	if (NO3D == viewMode)
		InitializeNameRects();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateEquitorialCoordsMenu(CCmdUI* pCmdUI) 
{
	if (coordType == EQUITORIAL)
		pCmdUI->m_pMenu->CheckMenuRadioItem(ID_VIEW_SETCOORDTYPE_EQUITORIALCOORDS,
											ID_VIEW_SETCOORDTYPE_GALACTICCOORDS,
											ID_VIEW_SETCOORDTYPE_EQUITORIALCOORDS,
											MF_BYCOMMAND);	
}

/***************************************************************************/
void CStereoStarView::OnSetGalacticCoords() 
{
	coordType = GALACTIC;
	theApp.WriteProfileInt("Settings", COORD_TYPE_KEY,	coordType);

	// ## kludge, if possible change this to convert origin from 
	// equitorial to galactic co-ords
	perspectiveEngine->origin.x = 0.0;
	perspectiveEngine->origin.y = 0.0;
	perspectiveEngine->origin.z = 0.0;
	distanceFilter = FALSE;
	theApp.WriteProfileInt("Settings", DISTANCE_FILTER_KEY,	distanceFilter);

	ConfigureScrolling();	
	CalcEye();
	if (NO3D == viewMode)
		InitializeNameRects();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateGalacticCoordsMenu(CCmdUI* pCmdUI) 
{
	if (coordType == GALACTIC)
		pCmdUI->m_pMenu->CheckMenuRadioItem(ID_VIEW_SETCOORDTYPE_EQUITORIALCOORDS,
											ID_VIEW_SETCOORDTYPE_GALACTICCOORDS,
											ID_VIEW_SETCOORDTYPE_GALACTICCOORDS,
											MF_BYCOMMAND);	
}

/***************************************************************************/
void CStereoStarView::OnShowLines() 
{
	showLines = !showLines;
	theApp.WriteProfileInt("Settings", SHOW_LINES_KEY,	showLines);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateShowLinesMenu(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(showLines);
}

/***************************************************************************/
void CStereoStarView::EmptyEyeLists() 
{
	DuoPoint*	thePoint;
	int			eyeCount = theEye[LEFT].GetCount();

	for (int a = 0; a < eyeCount; a++) {
		thePoint = (DuoPoint*)theEye[LEFT].GetAt(theEye[LEFT].FindIndex(a));
		delete thePoint;
		thePoint = (DuoPoint*)theEye[RIGHT].GetAt(theEye[RIGHT].FindIndex(a));
		delete thePoint;
	}
	theEye[LEFT].RemoveAll();
	theEye[RIGHT].RemoveAll();
}

/***************************************************************************/
void CStereoStarView::EmptyLineList(int lineType) 
{
	CStarLine*	theStarLine;

	int	numLines = lines[lineType].GetCount();
	for (int a = 0; a < numLines; a++) {
		theStarLine = (CStarLine*)lines[lineType].GetAt(lines[lineType].FindIndex(a));
		delete theStarLine;
	}
	lines[lineType].RemoveAll();
}

/***************************************************************************/
void CStereoStarView::EmptyAllLineLists() 
{
	for (int b = 0; b < NUM_LINE_TYPES; b++)
		EmptyLineList(b);
}

/***************************************************************************/
void CStereoStarView::EmptyAltLists() 
{
	DuoPoint*	thePoint;
	int			eyeCount = altitude[LEFT].GetCount();

	for (int a = 0; a < eyeCount; a++) {
		thePoint = (DuoPoint*)altitude[LEFT].GetAt(altitude[LEFT].FindIndex(a));
		delete thePoint;
		thePoint = (DuoPoint*)altitude[RIGHT].GetAt(altitude[RIGHT].FindIndex(a));
		delete thePoint;
	}
	altitude[LEFT].RemoveAll();
	altitude[RIGHT].RemoveAll();
}

/***************************************************************************/
void CStereoStarView::OnSetScaleFactor() 
{
	CScaleFactorDlog	dlg;

	dlg.m_Scale_Factor = scaleFactor[scaleMode];
	if  (dlg.DoModal() == IDOK)
	{
		UpdateScaleFactor(dlg.m_Scale_Factor);
		theMainFrame->m_Spin_Scale_Ctrl.SetPos(scaleFactor[scaleMode]);
	}
}

/***************************************************************************/
void CStereoStarView::OnShowNames() 
{
	showNames = !showNames;
	theApp.WriteProfileInt("Settings", SHOW_NAMES_KEY,	showNames);
	if (NO3D == viewMode)
		InitializeNameRects();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateShowNamesMenu(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(showNames);
}

/***************************************************************************/
void CStereoStarView::OnUpdateCoordType(CCmdUI* pCmdUI) 
{
    CString strPage;

	pCmdUI->Enable();
	switch(coordType)
	{
	case EQUITORIAL:	strPage = "EQUITORIAL";	break;
	case GALACTIC:		strPage = "GALACTIC";	break;
	default:			strPage = "none";		break;
	}
    pCmdUI->SetText( strPage ); 
}

/***************************************************************************/
void CStereoStarView::OnUpdateViewMode(CCmdUI* pCmdUI) 
{
    CString strPage;

	pCmdUI->Enable();
	switch(viewMode)
	{
	case CROSSEYE:	strPage = "Cross-Eyed";	break;
	case WIDEEYE:	strPage = "Wide-Eyed";	break;
	case ANAGLYPH:	strPage = "Anaglyph";	break;
	case NO3D:		strPage = "No 3D";		break;
	default:		strPage = "none";		break;
	}
    pCmdUI->SetText( strPage ); 
}

/***************************************************************************/
void CStereoStarView::OnUpdateScaleFactor(CCmdUI* pCmdUI) 
{
    CString strPage;

	pCmdUI->Enable();
	strPage.Format( "Scale: %.0f", scaleFactor[scaleMode] ); 
    pCmdUI->SetText( strPage ); 
}

/***************************************************************************/
void CStereoStarView::OnUpdateLineLimit(CCmdUI* pCmdUI) 
{
    CString strPage;

	pCmdUI->Enable();
	if ((showLine[LIMIT_LINE]) && (showLines)) {
		strPage.Format( "Lim: %.1f", lineLimit ); 
	}
	else {
		strPage.Empty();
	}
    pCmdUI->SetText( strPage ); 
}

/***************************************************************************/
void CStereoStarView::OnUpdateEyeLoc(CCmdUI* pCmdUI) 
{
    CString strPage;

	pCmdUI->Enable();
	if (viewMode != NO3D) {
		strPage.Format( "Eye: %3.1f/%3.1f/%3.1f", 
			perspectiveEngine->center.x, 
			perspectiveEngine->center.y, 
			perspectiveEngine->center.z ); 
	}
	else {
		strPage.Empty();
	}
    pCmdUI->SetText( strPage ); 
}

/***************************************************************************/
void CStereoStarView::OnUpdateButtonAnaglyph(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(viewMode == ANAGLYPH);
}

/***************************************************************************/
void CStereoStarView::OnUpdateButtonCrosseye(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(viewMode == CROSSEYE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateButtonNo3d(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(viewMode == NO3D);
}

/***************************************************************************/
void CStereoStarView::OnUpdateButtonWideeye(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(viewMode == WIDEEYE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateButtonEquitorial(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(coordType == EQUITORIAL);
}

/***************************************************************************/
void CStereoStarView::OnUpdateButtonGalactic(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(coordType == GALACTIC);
}

/***************************************************************************/
void CStereoStarView::ChangeScaleFactor(double newFactor) 
{
	scaleFactor[scaleMode] = newFactor;
	if (viewMode == NO3D)		// in other modes, offscreen bitmap remains same size at all scales
		ConfigureScrolling();	
}

/***************************************************************************/
void CStereoStarView::UpdateViewAngle(double newAngle)
{
	if ((newAngle > -1.0) && (newAngle < 91.0))
	{
		perspectiveEngine->setViewAngle(newAngle);
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::UpdateScaleFactor(double newFactor)
{
	ChangeScaleFactor(newFactor);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::ChangeScreenDimensions(short newWidth, short newHeight)
{
	SX = newWidth;
	SY = newHeight;
	SCX = (SX/2);
	SCY = (SY/2);
	SCXL = (SX/4);
	SCXR = (SCX+SCXL);
	scx[LEFT][CROSSEYE] = SCXR;
	scx[RIGHT][CROSSEYE] = SCXL;
	scx[LEFT][WIDEEYE] = SCXL;
	scx[RIGHT][WIDEEYE] = SCXR;
	scx[LEFT][ANAGLYPH] = SCX;
	scx[RIGHT][ANAGLYPH] = SCX;
	scx[LEFT][NO3D] = SCX;
	scx[RIGHT][NO3D] = SCX;
}

/***************************************************************************/
void CStereoStarView::UpdateOffscreenBitmap()
{
	if (!offscreenDCInit)
		return;

	CPoint	oldOrg;

	theDoc = GetDocument();

	offscreenDC.SelectClipRgn(NULL);	// going to, say, cross-eye mode then no3D mode screws up
										// the clipping region. This resets it.

	// if not an anaglyph, fill background with currentBackgroundColor
	if (viewMode != ANAGLYPH) 
		offscreenDC.FillSolidRect(offscreenRect, currentBackgroundColor);
	else
		offscreenDC.FillSolidRect(offscreenRect, WHITECOLOR);
	
	if (viewMode == NO3D)	// center the map in the bitmap
	{						// even if the axis center is not in the map center
		oldOrg = offscreenDC.GetViewportOrg();

		double	xDelta	=	axisCoords[AXISX][PLUSAXIS ][coordType].x + 
							axisCoords[AXISX][MINUSAXIS ][coordType].x;
		xDelta /= 2.0;
		xDelta *= scaleFactor[scaleMode];
		double	yDelta	=	axisCoords[AXISY][PLUSAXIS ][coordType].y + 
							axisCoords[AXISY][MINUSAXIS ][coordType].y;
		yDelta /= 2.0;
		yDelta *= scaleFactor[scaleMode];

		offscreenDC.SetViewportOrg(	oldOrg.x - xDelta, oldOrg.y + yDelta);
	}

	// if in a dual-pane mode, draw the dividing centerline
	if ((viewMode == CROSSEYE) || (viewMode == 	WIDEEYE))
	{
		CPen		thePen(PS_SOLID,0, GRAYCOLOR);
		CPen*		oldPen;
		oldPen = (CPen*)offscreenDC.SelectObject(&thePen);
		offscreenDC.MoveTo(SCX,0);
		offscreenDC.LineTo(SCX,SY);
		offscreenDC.SelectObject(oldPen);
	}

	// if in "include lines" mode, draw the lines
	if (showLines)
	{
		switch (viewMode)
		{
			case CROSSEYE:
			case WIDEEYE:	PlotAltCrossWide((CPaintDC*)&offscreenDC);	break;
			case ANAGLYPH:	PlotAltAnaglyph((CPaintDC*)&offscreenDC);	break;
		}
		if (showXYZAxis)
		{
			switch (viewMode)
			{
				case NO3D:		PlotAxisNo3D((CPaintDC*)&offscreenDC);	break;
				case CROSSEYE:
				case WIDEEYE:	PlotAxisCrossWide((CPaintDC*)&offscreenDC);	break;
				case ANAGLYPH:	PlotAxisAnaglyph((CPaintDC*)&offscreenDC);	break;
			}
		}
		if ((showPlane[XY]) && (NO3D == viewMode))
			PlotGridNo3D((CPaintDC*)&offscreenDC);

		PlotLine((CPaintDC*)&offscreenDC);
	}

	PlotStar((CPaintDC*)&offscreenDC);

	if (viewMode == NO3D)
	{
		offscreenDC.SetViewportOrg(oldOrg);
	}
}

/***************************************************************************/
void CStereoStarView::PlotAxisCrossWide(CPaintDC* dc)
{
	CRgn		theClip;
	CFont*		oldFont;
	UINT		oldAlign;
	CString		label[NUMAXIS][NUMSIGN];

	label[AXISX][PLUSAXIS] = "+X";
	label[AXISY][PLUSAXIS] = "+Y";
	label[AXISZ][PLUSAXIS] = "+Z";
	label[AXISX][MINUSAXIS] = "-X";
	label[AXISY][MINUSAXIS] = "-Y";
	label[AXISZ][MINUSAXIS] = "-Z";

	oldFont = dc->SelectObject(coordFont);
	oldAlign = dc->SetTextAlign(TA_BASELINE);
	dc->SetBkMode(TRANSPARENT);
	dc->SetTextColor(currentCoordColor);

	for (int eye = 0; eye < NUMEYES; eye++)
	{
		if (eye == LEFT)
		{
			if (viewMode == CROSSEYE)	theClip.CreateRectRgn(SCX, 0, SX, SY);
			else						theClip.CreateRectRgn(0, 0, SCX, SY);
		}
		else
		{
			if (viewMode == CROSSEYE)	theClip.CreateRectRgn(0, 0, SCX, SY);
			else						theClip.CreateRectRgn(SCX, 0, SX, SY);
		}
		dc->SelectClipRgn(&theClip);
		theClip.DeleteObject();

		for (int a = 0; a < NUMAXIS; a++)
		{
			DrawLine(dc, ScaleX(axis[a][PLUSAXIS][eye].x, eye), ScaleY(axis[a][PLUSAXIS][eye].y), 
				 ScaleX(axis[a][MINUSAXIS][eye].x, eye), ScaleY(axis[a][MINUSAXIS][eye].y), currentAxisColor);
			for (int b = 0; b < NUMSIGN; b++)
			{
				dc->TextOut(ScaleX(axis[a][b][eye].x, eye), 
					ScaleY(axis[a][b][eye].y), label[a][b], label[a][b].GetLength());
			}
		}
	}

	theClip.CreateRectRgn(0, 0, SX, SY);
	dc->SelectClipRgn(&theClip);
	theClip.DeleteObject();

	dc->SetTextColor(BLACKCOLOR);
	dc->SelectObject(oldFont);
	dc->SetTextAlign(oldAlign);
}

/***************************************************************************/
void CStereoStarView::PlotAxisAnaglyph(CPaintDC* dc)
{
	int			oldMode;
	CFont*		oldFont;
	UINT		oldAlign;
	CString		label[NUMAXIS][NUMSIGN];

	label[AXISX][PLUSAXIS] = "+X";
	label[AXISY][PLUSAXIS] = "+Y";
	label[AXISZ][PLUSAXIS] = "+Z";
	label[AXISX][MINUSAXIS] = "-X";
	label[AXISY][MINUSAXIS] = "-Y";
	label[AXISZ][MINUSAXIS] = "-Z";

	oldMode = dc->SetROP2(R2_MASKPEN);
	oldFont = dc->SelectObject(coordFont);
	oldAlign = dc->SetTextAlign(TA_BASELINE);
	dc->SetBkMode(TRANSPARENT);

	for (int a = 0; a < NUMAXIS; a++)
	{
		for (int eye = 0; eye < NUMEYES; eye++)
		{
			DrawLine(dc, ScaleX(axis[a][PLUSAXIS][eye].x, LEFT), ScaleY(axis[a][PLUSAXIS][eye].y), 
				 ScaleX(axis[a][MINUSAXIS][eye].x, LEFT), ScaleY(axis[a][MINUSAXIS][eye].y), anaglyphColor[eye]);
			dc->SetTextColor(anaglyphColor[eye]);
			for (int b = 0; b < NUMSIGN; b++)
			{
				dc->TextOut(ScaleX(axis[a][b][eye].x, eye), 
					ScaleY(axis[a][b][eye].y), label[a][b], label[a][b].GetLength());
			}
		}
	}

	dc->SetTextColor(BLACKCOLOR);
	dc->SelectObject(oldFont);
	dc->SetTextAlign(oldAlign);
	dc->SetROP2(oldMode);
}


/***************************************************************************/
void CStereoStarView::OnViewShowDecimals() 
{
	showDecimalCoord = !showDecimalCoord;
	theApp.WriteProfileInt("Settings", SHOW_DECIMAL_COORD_KEY,	showDecimalCoord);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateViewShowDecimals(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(showDecimalCoord);
}

/***************************************************************************/
void CStereoStarView::OnStarImageCrosshairs() 
{
	showBitmapStars = FALSE;
	theApp.WriteProfileInt("Settings", SHOW_BITMAP_STARS_KEY,	showBitmapStars);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateStarImageCrosshairs(CCmdUI* pCmdUI) 
{
	if (!showBitmapStars)
		pCmdUI->m_pMenu->CheckMenuRadioItem(ID_VIEW_STARIMAGE_PICTURES,
											ID_VIEW_STARIMAGE_CROSSHAIRS,
											ID_VIEW_STARIMAGE_CROSSHAIRS,
											MF_BYCOMMAND);	
}

/***************************************************************************/
void CStereoStarView::OnStarImagePictures() 
{
	showBitmapStars = TRUE;
	theApp.WriteProfileInt("Settings", SHOW_BITMAP_STARS_KEY,	showBitmapStars);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateStarImagePictures(CCmdUI* pCmdUI) 
{
	if (showBitmapStars)
		pCmdUI->m_pMenu->CheckMenuRadioItem(ID_VIEW_STARIMAGE_PICTURES,
											ID_VIEW_STARIMAGE_CROSSHAIRS,
											ID_VIEW_STARIMAGE_PICTURES,
											MF_BYCOMMAND);	
}
/***************************************************************************/
void CStereoStarView::PlotAltCrossWide(CPaintDC* dc)
{
	CRgn		theClip;
	DuoPoint*	startEye;
	DuoPoint*	endEye;
	int			a;
	int			numStars;

	theDoc = GetDocument();

	for (int eye = 0; eye < NUMEYES; eye++)
	{
		if (eye == LEFT)
		{
			if (viewMode == CROSSEYE)	theClip.CreateRectRgn(SCX, 0, SX, SY);
			else						theClip.CreateRectRgn(0, 0, SCX, SY);
		}
		else
		{
			if (viewMode == CROSSEYE)	theClip.CreateRectRgn(0, 0, SCX, SY);
			else						theClip.CreateRectRgn(SCX, 0, SX, SY);
		}
		dc->SelectClipRgn(&theClip);
		theClip.DeleteObject();

		for (a = 0; a < NUMPLANES; a++)
		{
			if (showPlane[a])
			{
				DrawLine(dc, ScaleX(plane[a][UPPERLEFT][eye].x, eye), ScaleY(plane[a][UPPERLEFT][eye].y), 
					ScaleX(plane[a][UPPERRIGHT][eye].x, eye), ScaleY(plane[a][UPPERRIGHT][eye].y), currentPlaneColor[a]);

				DrawLine(dc, ScaleX(plane[a][UPPERRIGHT][eye].x, eye), ScaleY(plane[a][UPPERRIGHT][eye].y), 
					ScaleX(plane[a][LOWERRIGHT][eye].x, eye), ScaleY(plane[a][LOWERRIGHT][eye].y), currentPlaneColor[a]);

				DrawLine(dc, ScaleX(plane[a][LOWERRIGHT][eye].x, eye), ScaleY(plane[a][LOWERRIGHT][eye].y), 
					ScaleX(plane[a][LOWERLEFT][eye].x, eye), ScaleY(plane[a][LOWERLEFT][eye].y), currentPlaneColor[a]);

				DrawLine(dc, ScaleX(plane[a][LOWERLEFT][eye].x, eye), ScaleY(plane[a][LOWERLEFT][eye].y), 
					ScaleX(plane[a][UPPERLEFT][eye].x, eye), ScaleY(plane[a][UPPERLEFT][eye].y), currentPlaneColor[a]);
			}
		}


		if (showLineAlt[XY])
		{
			// draw altitude lines, left view
			numStars = theDoc->GetNumStars();
			for (a = 0; a < numStars; a++)
			{
				if (StarVisible(a))
				{
					startEye = (DuoPoint*)theEye[eye].GetAt(theEye[eye].FindIndex(a));
					endEye = (DuoPoint*)altitude[eye].GetAt(altitude[eye].FindIndex(a));

					DrawLine(dc, ScaleX(startEye->x, eye), ScaleY(startEye->y), 
						ScaleX(endEye->x, eye), ScaleY(endEye->y), currentAltLineColor);
				}
			}
		}

		if (showRadials)
		{
			// draw radial lines, left view
			numStars = theDoc->GetNumStars();
			for (a = 0; a < numStars; a++)
			{
				if (StarVisible(a))
				{
					endEye = (DuoPoint*)altitude[eye].GetAt(altitude[eye].FindIndex(a));

					DrawLine(dc, ScaleX(planeCenter[eye].x, eye), ScaleY(planeCenter[eye].y), 
						ScaleX(endEye->x, eye), ScaleY(endEye->y), currentAltLineColor);
				}
			}
		}
	}

	/************/
	/* Clean Up */ 
	/************/
	theClip.CreateRectRgn(0, 0, SX, SY);
	dc->SelectClipRgn(&theClip);
	theClip.DeleteObject();
}

/***************************************************************************/
void CStereoStarView::PlotAltAnaglyph(CPaintDC* dc)
{
	int			oldMode;
	DuoPoint*	startEye;
	DuoPoint*	endEye;
	int			a;
	int			numStars;

	oldMode = dc->SetROP2(R2_MASKPEN);

	theDoc = GetDocument();

	for (int eye = 0; eye < NUMEYES; eye++)
	{
		for (a = 0; a < NUMPLANES; a ++)
		{
			if (showPlane[a])
			{
				DrawLine(dc, ScaleX(plane[a][UPPERLEFT][eye].x, eye), ScaleY(plane[a][UPPERLEFT][eye].y), 
					ScaleX(plane[a][UPPERRIGHT][eye].x, eye), ScaleY(plane[a][UPPERRIGHT][eye].y), anaglyphColor[eye]);

				DrawLine(dc, ScaleX(plane[a][UPPERRIGHT][eye].x, eye), ScaleY(plane[a][UPPERRIGHT][eye].y), 
					ScaleX(plane[a][LOWERRIGHT][eye].x, eye), ScaleY(plane[a][LOWERRIGHT][eye].y), anaglyphColor[eye]);

				DrawLine(dc, ScaleX(plane[a][LOWERRIGHT][eye].x, eye), ScaleY(plane[a][LOWERRIGHT][eye].y), 
					ScaleX(plane[a][LOWERLEFT][eye].x, eye), ScaleY(plane[a][LOWERLEFT][eye].y), anaglyphColor[eye]);

				DrawLine(dc, ScaleX(plane[a][LOWERLEFT][eye].x, eye), ScaleY(plane[a][LOWERLEFT][eye].y), 
					ScaleX(plane[a][UPPERLEFT][eye].x, eye), ScaleY(plane[a][UPPERLEFT][eye].y), anaglyphColor[eye]);
			}
		}


		if (showLineAlt[XY])
		{
			numStars = theDoc->GetNumStars();
			for (a = 0; a < numStars; a++)
			{
				if (StarVisible(a))
				{
					startEye = (DuoPoint*)theEye[eye].GetAt(theEye[eye].FindIndex(a));
					endEye = (DuoPoint*)altitude[eye].GetAt(altitude[eye].FindIndex(a));

					DrawLine(dc, ScaleX(startEye->x, eye), ScaleY(startEye->y), 
						ScaleX(endEye->x, eye), ScaleY(endEye->y), anaglyphColor[eye]);
				}
			}
		}

		if (showRadials)
		{
			numStars = theDoc->GetNumStars();
			for (a = 0; a < numStars; a++)
			{
				if (StarVisible(a))
				{
					endEye = (DuoPoint*)altitude[eye].GetAt(altitude[eye].FindIndex(a));

					DrawLine(dc, ScaleX(planeCenter[eye].x, eye), ScaleY(planeCenter[eye].y), 
						ScaleX(endEye->x, eye), ScaleY(endEye->y), anaglyphColor[eye]);
				}
			}
		}
	}

	dc->SetROP2(oldMode);
}

/***************************************************************************/
void CStereoStarView::OnAltitudeLine() 
{
	showLineAlt[XY] = !showLineAlt[XY];
	theApp.WriteProfileInt("Settings", SHOW_LINE_ALT_XY_KEY,	showLineAlt[XY]);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateAltitudeLine(CCmdUI* pCmdUI) 
{
	if ((!showLines) || (NO3D == viewMode))
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showLineAlt[XY]);
}

/***************************************************************************/
void CStereoStarView::OnShowXYPane() 
{
	showPlane[XY] = !showPlane[XY];
	theApp.WriteProfileInt("Settings", SHOW_XY_PLANE_KEY,	showPlane[XY]);
//	CalcLine();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateShowxXYPlane(CCmdUI* pCmdUI) 
{
	if (!showLines)
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showPlane[XY]);
}

/***************************************************************************/
void CStereoStarView::OnShowXZplane() 
{
	showPlane[XZ] = !showPlane[XZ];
	theApp.WriteProfileInt("Settings", SHOW_XZ_PLANE_KEY,	showPlane[XZ]);
//	CalcLine();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateShowXZplane(CCmdUI* pCmdUI) 
{
	if ((!showLines) || (NO3D == viewMode))
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showPlane[XZ]);
}

/***************************************************************************/
void CStereoStarView::OnShowYZplane() 
{
	showPlane[YZ] = !showPlane[YZ];
	theApp.WriteProfileInt("Settings", SHOW_YZ_PLANE_KEY,	showPlane[YZ]);
//	CalcLine();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateShowYZplane(CCmdUI* pCmdUI) 
{
	if ((!showLines) || (NO3D == viewMode))
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showPlane[YZ]);
}

/***************************************************************************/
void CStereoStarView::OnLineShadow() 
{
	showLineShadow = !showLineShadow;
	theApp.WriteProfileInt("Settings", SHOW_LINE_SHADOW_KEY,	showLineShadow);
//	CalcLine();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateLineShadow(CCmdUI* pCmdUI) 
{
	if ((!showLines) || (NO3D == viewMode))
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showLineShadow);
}

/***************************************************************************/
COLORREF CStereoStarView::GetColor(COLORREF currentColor)
{
	CColorDialog	colorDlg(0, CC_RGBINIT | CC_FULLOPEN);
	static DWORD	dwCustColors[16];

	colorDlg.m_cc.rgbResult = currentColor;
	colorDlg.m_cc.lpCustColors = dwCustColors;

	if  (colorDlg.DoModal() == IDOK)	return colorDlg.GetColor();
	else								return currentColor;
}

/***************************************************************************/
void CStereoStarView::OnSetLineColor() 
{
	currentLineColor = GetColor(currentLineColor);	
	WriteColorToRegistry(currentLineColor, LINE_COLOR_KEY);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSetAltitudeLineColor() 
{
	currentAltLineColor = GetColor(currentAltLineColor);	
	WriteColorToRegistry(currentAltLineColor, ALT_COLOR_KEY);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSetNameColor() 
{
	currentNameColor = GetColor(currentNameColor);	
	WriteColorToRegistry(currentNameColor, NAME_COLOR_KEY);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSetBackgroundColor() 
{
	currentBackgroundColor = GetColor(currentBackgroundColor);	
	WriteColorToRegistry(currentBackgroundColor, BG_COLOR_KEY);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSetCoordColor() 
{
	currentCoordColor = GetColor(currentCoordColor);	
	WriteColorToRegistry(currentCoordColor, COORD_COLOR_KEY);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}


/***************************************************************************/
void CStereoStarView::GetFont(CFont* theFont, COLORREF* currentColor, CString* fontTypeFace, int* fontPoints) 
{
	LOGFONT		lf;
	CDC*		dc = GetDC();
	long		lfHeight;
	theFont->GetLogFont(&lf); 
	CFontDialog	fontDlg(&lf, CF_INITTOLOGFONTSTRUCT | CF_SCREENFONTS | CF_EFFECTS | CF_NOSCRIPTSEL);

	fontDlg.m_cf.rgbColors = *currentColor;

	if  (fontDlg.DoModal() == IDOK)
	{
		theFont->DeleteObject();
		theFont->CreateFontIndirect(fontDlg.m_cf.lpLogFont);

		*fontTypeFace = fontDlg.m_cf.lpLogFont->lfFaceName;
		lfHeight = fontDlg.m_cf.lpLogFont->lfHeight;
		*fontPoints = -MulDiv(lfHeight, 72, dc->GetDeviceCaps(LOGPIXELSY));
//		*currentColor = fontDlg.m_cf.rgbColors;
	}
}

/***************************************************************************/
void CStereoStarView::OnSetCoordFont() 
{
	CString		fontTypeName;
	int			fontPoints;

	GetFont(coordFont, &currentNameColor, &fontTypeName, &fontPoints);

	theApp.WriteProfileString("Settings", COORD_FONT_TYPEFACE_KEY,	fontTypeName);
	theApp.WriteProfileInt(   "Settings", COORD_FONT_POINT_KEY,		fontPoints);

	if (NO3D == viewMode)
		InitializeNameRects();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSetNameFont() 
{
	CString		fontTypeName;
	int			fontPoints;

	GetFont(nameFont, &currentNameColor, &fontTypeName, &fontPoints);

	theApp.WriteProfileString("Settings", NAME_FONT_TYPEFACE_KEY,	fontTypeName);
	theApp.WriteProfileInt(   "Settings", NAME_FONT_POINT_KEY,		fontPoints);

	if (NO3D == viewMode)
		InitializeNameRects();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSaveAsBitmap() 
{
	CFileDialog	dlg(FALSE, "BMP", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "Bmp Files\0*.bmp\0\0", NULL);
    PBITMAPINFO pbmi; 
	CString		thePath;
    CClientDC   viewDC(this);	// View is an hWnd, so we can use "this"
    CDC         memDC;			// Handle to a memory DC
    CRect		rc;				// For storing the size of the window
    CBitmap     cBmp;
	BITMAP		theBitmap;

	// get the file's name from user
	if (dlg.DoModal() == IDOK)
	{
		// create a DC containing a bitmap with the offscreen bitmap in it
		memDC.CreateCompatibleDC(&offscreenDC);															// Create the memory DC.
		cBmp.CreateCompatibleBitmap(&offscreenDC, offscreenRect.Width(),offscreenRect.Height() );		// Create a compatible bitmap for memDC
		memDC.SelectObject(&cBmp);																		// Select cBmp into memDC
		memDC.BitBlt(0, 0, offscreenRect.Width(),offscreenRect.Height(), &offscreenDC, 0, 0, SRCCOPY);	// copy view's bitmap into memDC's bitmap
		cBmp.GetBitmap(&theBitmap);

		// make the PBITMAPINFO
		pbmi = CreateBitmapInfoStruct(this->m_hWnd, &theBitmap);

		// write the BMP file
		thePath = dlg.GetPathName();
		CreateBMPFile(this->m_hWnd ,  LPCTSTR(thePath), pbmi, HBITMAP(cBmp), memDC.m_hDC);
	}
}
// end CStereoStarView::OnSaveAsBitmap

/***************************************************************************/
PBITMAPINFO CStereoStarView::CreateBitmapInfoStruct(HWND hwnd, BITMAP* bmp)
{
	PBITMAPINFO	pbmi; 
	WORD		cClrBits; 
 
    /* Convert the color format to a count of bits. */ 
 
    cClrBits = (WORD)(bmp->bmPlanes * bmp->bmBitsPixel); 
 
    if (cClrBits == 1) 
        cClrBits = 1; 
    else if (cClrBits <= 4) 
        cClrBits = 4; 
    else if (cClrBits <= 8) 
        cClrBits = 8; 
    else if (cClrBits <= 16) 
        cClrBits = 16; 
    else if (cClrBits <= 24) 
        cClrBits = 24; 
    else 
        cClrBits = 32; 
 
    // Allocate memory for the BITMAPINFO structure. 
    // (This structure contains a BITMAPINFOHEADER structure 
    //  and an array of RGBQUAD data structures) 
    if (cClrBits != 24) 
         pbmi = (PBITMAPINFO) LocalAlloc(LPTR, 
                    sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * (2^cClrBits)); 
    else	// There is no RGBQUAD array for the 24-bit-per-pixel format. 
         pbmi = (PBITMAPINFO) LocalAlloc(LPTR, 
                    sizeof(BITMAPINFOHEADER)); 
 
    /* Initialize the fields in the BITMAPINFO structure. */ 
    pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER); 
    pbmi->bmiHeader.biWidth = bmp->bmWidth; 
    pbmi->bmiHeader.biHeight = bmp->bmHeight; 
    pbmi->bmiHeader.biPlanes = bmp->bmPlanes; 
    pbmi->bmiHeader.biBitCount = bmp->bmBitsPixel; 
    if (cClrBits < 24) 
        pbmi->bmiHeader.biClrUsed = 2^cClrBits; 
 
    /* If the bitmap is not compressed, set the BI_RGB flag. */ 
    pbmi->bmiHeader.biCompression = BI_RGB; 
 
    // Compute the number of bytes in the array of color  indices and store the result in biSizeImage. 
    pbmi->bmiHeader.biSizeImage = (pbmi->bmiHeader.biWidth + 7) /8 
                                  * pbmi->bmiHeader.biHeight 
                                  * cClrBits; 
 
    // Set biClrImportant to 0, indicating that all of the device colors are important. 
    pbmi->bmiHeader.biClrImportant = 0; 
 
    return pbmi; 
}
// end CStereoStarView::CreateBitmapInfoStruct

/***************************************************************************/
void CStereoStarView::CreateBMPFile(HWND hwnd, LPCTSTR pszFile, PBITMAPINFO pbi, HBITMAP hBMP, HDC hDC)
{
#define MAXWRITE	1024
	HANDLE hf;                  /* file handle */ 
	BITMAPFILEHEADER hdr;       /* bitmap file-header */ 
	PBITMAPINFOHEADER pbih;     /* bitmap info-header */ 
	LPBYTE lpBits;              /* memory pointer */ 
	DWORD dwTotal;              /* total count of bytes */ 
	DWORD cb;                   /* incremental count of bytes */ 
	BYTE *hp;                   /* byte pointer */ 
	DWORD dwTmp; 
 
 
    pbih = (PBITMAPINFOHEADER) pbi; 
    lpBits = (LPBYTE) GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);
	if (!lpBits) 
	{
		MessageBox("Not enough RAM to save BMP file", "GlobalAlloc error", MB_ICONEXCLAMATION); 
		return;
	}
 
    // Retrieve the color table (RGBQUAD array) and the bits (array of palette indices) from the DIB. 
    if (!GetDIBits(hDC, hBMP, 0, (WORD) pbih->biHeight, lpBits, pbi, DIB_RGB_COLORS)) 
	{
		MessageBox("Failure to fetch Device Independent Bitmap", "GetDIBits error", MB_ICONEXCLAMATION); 
		GlobalFree((HGLOBAL)lpBits);
		return;
	}
 
    /* Create the .BMP file. */ 
    hf = CreateFile(pszFile, 
                   GENERIC_READ | GENERIC_WRITE, 
                   (DWORD) 0, 
                   (LPSECURITY_ATTRIBUTES) NULL, 
                   CREATE_ALWAYS, 
                   FILE_ATTRIBUTE_NORMAL, 
                   (HANDLE) NULL); 
	if (hf == INVALID_HANDLE_VALUE) 
	{
		MessageBox("Failure to create BMP file on hard drive", "CreateFile error", MB_ICONEXCLAMATION); 
		GlobalFree((HGLOBAL)lpBits);
		return;
	}
 
    hdr.bfType = 0x4d42;        /* 0x42 = "B" 0x4d = "M" */ 
 
    /* Compute the size of the entire file. */ 
    hdr.bfSize = (DWORD) (	sizeof(BITMAPFILEHEADER) + 
							pbih->biSize + 
							pbih->biClrUsed * sizeof(RGBQUAD) + 
							pbih->biSizeImage); 
 
    hdr.bfReserved1 = 0; 
    hdr.bfReserved2 = 0; 
 
    /* Compute the offset to the array of color indices. */ 
    hdr.bfOffBits = (DWORD) sizeof(BITMAPFILEHEADER) + pbih->biSize + pbih->biClrUsed * sizeof (RGBQUAD); 
 
    /* Copy the BITMAPFILEHEADER into the .BMP file. */ 
 
    if (!WriteFile(hf, (LPVOID) &hdr, sizeof(BITMAPFILEHEADER), (LPDWORD) &dwTmp, (LPOVERLAPPED) NULL)) 
	{
		MessageBox("Failure while writing BMP header to file", "WriteFile error", MB_ICONEXCLAMATION); 
		CloseHandle(hf);
		GlobalFree((HGLOBAL)lpBits);
		return;
	}
 
    /* Copy the BITMAPINFOHEADER and RGBQUAD array into the file. */ 
	if (!WriteFile(hf, (LPVOID) pbih, sizeof(BITMAPINFOHEADER) + pbih->biClrUsed * sizeof (RGBQUAD), 
                  (LPDWORD) &dwTmp, (LPOVERLAPPED) NULL)) 
	{
		MessageBox("Failure while writing RGBQUAD array to file", "WriteFile error", MB_ICONEXCLAMATION); 
		CloseHandle(hf);
		GlobalFree((HGLOBAL)lpBits);
		return;
	}
 
    /* Copy the array of color indices into the .BMP file. */ 
    dwTotal = cb = pbih->biSizeImage; 
    hp = lpBits; 
	while (cb > MAXWRITE)  { 
		if (!WriteFile(hf, (LPSTR) hp, (int) MAXWRITE, (LPDWORD) &dwTmp, (LPOVERLAPPED) NULL)) 
		{
			MessageBox("Failure while writing bitmap to file", "WriteFile error", MB_ICONEXCLAMATION); 
			CloseHandle(hf);
			GlobalFree((HGLOBAL)lpBits);
			return;
		}
		cb-= MAXWRITE; 
		hp += MAXWRITE; 
    } 
    if (!WriteFile(hf, (LPSTR) hp, (int) cb, (LPDWORD) &dwTmp, (LPOVERLAPPED) NULL)) 
	{
		MessageBox("Failure while writing bitmap to file", "WriteFile error", MB_ICONEXCLAMATION); 
		CloseHandle(hf);
		GlobalFree((HGLOBAL)lpBits);
		return;
	}
 
    /* Close the .BMP file. */ 
    if (!CloseHandle(hf)) 
	{
		MessageBox("Failure while closing file", "CloseHandle error", MB_ICONEXCLAMATION); 
		GlobalFree((HGLOBAL)lpBits);
		return;
	}
 
    /* Free memory. */
    GlobalFree((HGLOBAL)lpBits);
}
// end CStereoStarView::CreateBMPFile

/***************************************************************************/
void CStereoStarView::OnSetXYPlaneColor() 
{
	currentPlaneColor[XY] = GetColor(currentPlaneColor[XY]);	
	WriteColorToRegistry(currentPlaneColor[XY], PLANE_XY_COLOR_KEY);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}
// end CStereoStarView::OnSetXYPlaneColor

/***************************************************************************/
void CStereoStarView::OnSetXZPaneColor() 
{
	currentPlaneColor[XZ] = GetColor(currentPlaneColor[XZ]);	
	WriteColorToRegistry(currentPlaneColor[XZ], PLANE_XZ_COLOR_KEY);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSetYZPlaneColor() 
{
	currentPlaneColor[YZ] = GetColor(currentPlaneColor[YZ]);	
	WriteColorToRegistry(currentPlaneColor[YZ], PLANE_YZ_COLOR_KEY);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateSpinThetaToolbar(CCmdUI* pCmdUI) 
{
	if ( viewMode == NO3D)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSpinTheta(CCmdUI* pCmdUI) 
{
	if (perspectiveEngine->thetaDegrees != theMainFrame->m_Spin_Theta_Ctrl.GetPos())
	{
		perspectiveEngine->setTheta(theMainFrame->m_Spin_Theta_Ctrl.GetPos());
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnUpdateSpinPhiToolbar(CCmdUI* pCmdUI) 
{
	if ( viewMode == NO3D)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSpinPhi(CCmdUI* pCmdUI) 
{
	if (perspectiveEngine->phiDegrees != theMainFrame->m_Spin_Phi_Ctrl.GetPos())
	{
		perspectiveEngine->setPhi(theMainFrame->m_Spin_Phi_Ctrl.GetPos());
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnUpdateSpinRhoToolbar(CCmdUI* pCmdUI) 
{
	if ( viewMode == NO3D)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSpinRho(CCmdUI* pCmdUI) 
{
	if (perspectiveEngine->rhoValue != theMainFrame->m_Spin_Rho_Ctrl.GetPos())
	{
		perspectiveEngine->setRho(theMainFrame->m_Spin_Rho_Ctrl.GetPos());
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnUpdateSpinScaleToolbar(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSpinScale(CCmdUI* pCmdUI) 
{
	if (scaleFactor[scaleMode] != theMainFrame->m_Spin_Scale_Ctrl.GetPos())
	{
		scaleFactor[scaleMode] = theMainFrame->m_Spin_Scale_Ctrl.GetPos();
		if (viewMode == NO3D)	// in other modes, offscreen bitmap remains constant at all scales
			ConfigureScrolling();	
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnUpdateSpinViewAngleToolbar(CCmdUI* pCmdUI) 
{
	if ( viewMode == NO3D)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSpinViewAngle(CCmdUI* pCmdUI) 
{
	double	newSeparation = theMainFrame->m_Spin_EyeSep_Ctrl.GetPos() / 10.0;

	if (perspectiveEngine->separation != newSeparation)
	{
		perspectiveEngine->setEyeSeparation(newSeparation);
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnUpdateSpinEyeSepToolbar(CCmdUI* pCmdUI) 
{
	if ( viewMode == NO3D)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSpinEyeSep(CCmdUI* pCmdUI) 
{
	if (perspectiveEngine->viewAngleDegrees != theMainFrame->m_Spin_ViewAngle_Ctrl.GetPos())
	{
		perspectiveEngine->setViewAngle(theMainFrame->m_Spin_ViewAngle_Ctrl.GetPos());
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnSetViewAngle() 
{
	CViewAngleDialog	dlg;

	dlg.m_View_Angle_Pos = perspectiveEngine->viewAngleDegrees / TICKSIZE;
	if  (dlg.DoModal() == IDOK)
	{
		perspectiveEngine->setViewAngle(dlg.m_View_Angle_Pos * TICKSIZE);
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnUpdateSetViewAngle(CCmdUI* pCmdUI) 
{
	if ( viewMode == NO3D)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

/***************************************************************************/
void CStereoStarView::OnSetEyeSeparation() 
{
	CEyeSeparationDialog	dlg;

	dlg.m_Eye_Separation = perspectiveEngine->separation;
	if  (dlg.DoModal() == IDOK)
	{
		perspectiveEngine->setEyeSeparation(dlg.m_Eye_Separation);
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnUpdateSetEyeSeparation(CCmdUI* pCmdUI) 
{
	if ( viewMode == NO3D)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateViewAngle(CCmdUI* pCmdUI) 
{
    CString strPage;

	pCmdUI->Enable();
	if (viewMode != NO3D) {
		strPage.Format( "Angle: %.0f", perspectiveEngine->viewAngleDegrees ); 
	}
	else {
		strPage.Empty();
	}
    pCmdUI->SetText( strPage ); 
}

/***************************************************************************/
void CStereoStarView::OnUpdateEyeSeparation(CCmdUI* pCmdUI) 
{
    CString strPage;

	pCmdUI->Enable();
	if (viewMode != NO3D) {
		strPage.Format( "Sep: %.1f", perspectiveEngine->separation * 10.0); 
	}
	else {
		strPage.Empty();
	}
    pCmdUI->SetText( strPage ); 
}

/***************************************************************************/
void CStereoStarView::OnSetLineTypesRadials() 
{
	showRadials = !showRadials;
	theApp.WriteProfileInt("Settings", SHOW_RADIALS_KEY,	showRadials);
//	CalcLine();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateSetLineTypesRadials(CCmdUI* pCmdUI) 
{
	if ((!showLines) || (NO3D == viewMode))
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showRadials);
}

/***************************************************************************/
void CStereoStarView::SetDisplayMode(UINT nID)
{
	short	oldViewMode = viewMode;

	switch(nID)
	{
	case ID_BUTTON_NO3D:
	case ID_VIEW_DISPLAYMODE_FLATVIEW:		viewMode = NO3D;		break;
	case ID_BUTTON_CROSSEYE:
	case ID_VIEW_DISPLAYMODE_CROSSEYEDVIEW:	viewMode = CROSSEYE;	break;
	case ID_BUTTON_WIDEEYE:
	case ID_VIEW_DISPLAYMODE_WIDEEYEDVIEW:	viewMode = WIDEEYE;		break;
	case ID_BUTTON_ANAGLYPH:
	case ID_VIEW_DISPLAYMODE_ANALGLYPHVIEW:	viewMode = ANAGLYPH;	break;
	}
	if ((NO3D == oldViewMode) || (NO3D == viewMode))
		ConfigureScrolling();	// non-NO3D modes share same scroll size

	theApp.WriteProfileInt("Settings", VIEW_MODE_KEY,	viewMode);

	scaleMode = (NO3D == viewMode) ? SCALE_NO_3D : SCALE_3D;
	theMainFrame->m_Spin_Scale_Ctrl.SetPos(scaleFactor[scaleMode]);

	if (NO3D == viewMode)
		InitializeNameRects();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::UpdateDisplayModeMenu(CCmdUI* pCmdUI)
{
	int		buttonChecked = -1;

	switch(viewMode)
	{
	case NO3D:
		if (pCmdUI->m_nID == ID_VIEW_DISPLAYMODE_FLATVIEW)
			buttonChecked = ID_VIEW_DISPLAYMODE_FLATVIEW; 		
		break;
	case CROSSEYE:	 
		if (pCmdUI->m_nID == ID_VIEW_DISPLAYMODE_CROSSEYEDVIEW)
				buttonChecked = ID_VIEW_DISPLAYMODE_CROSSEYEDVIEW; 
		break;
	case WIDEEYE:
		if (pCmdUI->m_nID == ID_VIEW_DISPLAYMODE_WIDEEYEDVIEW)
			buttonChecked = ID_VIEW_DISPLAYMODE_WIDEEYEDVIEW; 	
		break;
	case ANAGLYPH:
		if (pCmdUI->m_nID == ID_VIEW_DISPLAYMODE_ANALGLYPHVIEW)
			buttonChecked = ID_VIEW_DISPLAYMODE_ANALGLYPHVIEW; 
		break;
	}

	if (buttonChecked != -1)
		pCmdUI->m_pMenu->CheckMenuRadioItem(ID_VIEW_DISPLAYMODE_FLATVIEW,
											ID_VIEW_DISPLAYMODE_ANALGLYPHVIEW,
											buttonChecked,
											MF_BYCOMMAND);
}
/***************************************************************************/
void CStereoStarView::UpdateDisplayModeButton(CCmdUI* pCmdUI)
{
	switch(pCmdUI->m_nID)
	{
	case ID_BUTTON_NO3D:		pCmdUI->SetCheck(viewMode == NO3D);		break;
	case ID_BUTTON_CROSSEYE:	pCmdUI->SetCheck(viewMode == CROSSEYE);	break;
	case ID_BUTTON_WIDEEYE:		pCmdUI->SetCheck(viewMode == WIDEEYE);	break;
	case ID_BUTTON_ANAGLYPH:	pCmdUI->SetCheck(viewMode == ANAGLYPH);	break;
	}
}

/***************************************************************************/
void CStereoStarView::ShowSpectralClass(UINT nID)
{
	switch(nID)
	{
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSO:	
		showClass[CLASS_O] = !showClass[CLASS_O];	
		theApp.WriteProfileInt("Settings", SHOW_CLASS_O_KEY, showClass[CLASS_O]);
		break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSB:	
		showClass[CLASS_B] = !showClass[CLASS_B];	
		theApp.WriteProfileInt("Settings", SHOW_CLASS_B_KEY, showClass[CLASS_B]);
		break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSA:	
		showClass[CLASS_A] = !showClass[CLASS_A];	
		theApp.WriteProfileInt("Settings", SHOW_CLASS_A_KEY, showClass[CLASS_A]);
		break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSF:	
		showClass[CLASS_F] = !showClass[CLASS_F];	
		theApp.WriteProfileInt("Settings", SHOW_CLASS_F_KEY, showClass[CLASS_F]);
		break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSG:	
		showClass[CLASS_G] = !showClass[CLASS_G];	
		theApp.WriteProfileInt("Settings", SHOW_CLASS_G_KEY, showClass[CLASS_G]);
		break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSK:	
		showClass[CLASS_K] = !showClass[CLASS_K];	
		theApp.WriteProfileInt("Settings", SHOW_CLASS_K_KEY, showClass[CLASS_K]);
		break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSM:	
		showClass[CLASS_M] = !showClass[CLASS_M];	
		theApp.WriteProfileInt("Settings", SHOW_CLASS_M_KEY, showClass[CLASS_M]);
		break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSX:	
		showClass[CLASS_X] = !showClass[CLASS_X];	
		theApp.WriteProfileInt("Settings", SHOW_CLASS_X_KEY, showClass[CLASS_X]);
		break;
	}

	InitializeNameRects();
	CalcLine();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::UpdateSpectralClass(CCmdUI* pCmdUI)
{
	switch(pCmdUI->m_nID)
	{
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSO:	pCmdUI->SetCheck(showClass[CLASS_O]);	break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSB:	pCmdUI->SetCheck(showClass[CLASS_B]);	break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSA:	pCmdUI->SetCheck(showClass[CLASS_A]);	break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSF:	pCmdUI->SetCheck(showClass[CLASS_F]);	break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSG:	pCmdUI->SetCheck(showClass[CLASS_G]);	break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSK:	pCmdUI->SetCheck(showClass[CLASS_K]);	break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSM:	pCmdUI->SetCheck(showClass[CLASS_M]);	break;
	case ID_VIEW_SHOWSPECTRALCLASS_CLASSX:	pCmdUI->SetCheck(showClass[CLASS_X]);	break;
	}
}

/***************************************************************************/
void CStereoStarView::SetSpectralColor(UINT nID)
{
	switch(nID)
	{
	case ID_COLOR_SETSPECTRALCOLORS_CLASSO:	
		spectralColor[CLASS_O] = GetColor(spectralColor[CLASS_O]);	
		WriteColorToRegistry(spectralColor[CLASS_O], O_COLOR_KEY);
		break;
	case ID_COLOR_SETSPECTRALCOLORS_CLASSB:	
		spectralColor[CLASS_B] = GetColor(spectralColor[CLASS_B]);	
		WriteColorToRegistry(spectralColor[CLASS_B], B_COLOR_KEY);
		break;
	case ID_COLOR_SETSPECTRALCOLORS_CLASSA:	
		spectralColor[CLASS_A] = GetColor(spectralColor[CLASS_A]);	
		WriteColorToRegistry(spectralColor[CLASS_A], A_COLOR_KEY);
		break;
	case ID_COLOR_SETSPECTRALCOLORS_CLASSF:	
		spectralColor[CLASS_F] = GetColor(spectralColor[CLASS_F]);	
		WriteColorToRegistry(spectralColor[CLASS_F], F_COLOR_KEY);
		break;
	case ID_COLOR_SETSPECTRALCOLORS_CLASSG:	
		spectralColor[CLASS_G] = GetColor(spectralColor[CLASS_G]);	
		WriteColorToRegistry(spectralColor[CLASS_G], G_COLOR_KEY);
		break;
	case ID_COLOR_SETSPECTRALCOLORS_CLASSK:	
		spectralColor[CLASS_K] = GetColor(spectralColor[CLASS_K]);	
		WriteColorToRegistry(spectralColor[CLASS_K], K_COLOR_KEY);
		break;
	case ID_COLOR_SETSPECTRALCOLORS_CLASSM:	
		spectralColor[CLASS_M] = GetColor(spectralColor[CLASS_M]);	
		WriteColorToRegistry(spectralColor[CLASS_M], M_COLOR_KEY);
		break;
	case ID_COLOR_SETSPECTRALCOLORS_CLASSX:	
		spectralColor[CLASS_X] = GetColor(spectralColor[CLASS_X]);	
		WriteColorToRegistry(spectralColor[CLASS_X], X_COLOR_KEY);
		break;
	}
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnColorSetaxiscolor() 
{
	currentAxisColor = GetColor(currentAxisColor);	
	WriteColorToRegistry(currentAxisColor, AXIS_COLOR_KEY);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateXYZAxis(CCmdUI* pCmdUI) 
{
	if (!showLines)
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showXYZAxis);
}

/***************************************************************************/
void CStereoStarView::OnXYZAxis() 
{
	showXYZAxis = !showXYZAxis;
	theApp.WriteProfileInt("Settings", SHOW_XYZ_AXIS_KEY,	showXYZAxis);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnExcludeStarsTooDistant() 
{
	distanceFilter = !distanceFilter;	
	theApp.WriteProfileInt("Settings", DISTANCE_FILTER_KEY,	distanceFilter);
//	CalcLine();
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}

/***************************************************************************/
void CStereoStarView::OnUpdateExcludeStarsTooDistant(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(distanceFilter);
}
/***************************************************************************/
void CStereoStarView::Serialize(CArchive& ar)
{
	DWORD	theColor;
	int		a;
	double	dValue;

	CView::Serialize(ar);

	if (ar.IsStoring())
	{
		ar << viewMode;
		ar << showNames;
		ar << showLines;
		ar << lineLimit;
		ar << showLine[LIMIT_LINE];
		ar << showLine[CLOSEST_LINE];
		ar << showLine[CUSTOM_LINE];
		ar << showXYZAxis;
		ar << showPlane[XY];
		ar << showPlane[XZ];
		ar << showPlane[YZ];
		ar << showLineAlt[XY];
		ar << showLineAlt[XZ];
		ar << showLineAlt[YZ];
		ar << showLineShadow;
		ar << showRadials;
		ar << showCoords;
		ar << coordType;
		ar << showClass[CLASS_O];
		ar << showClass[CLASS_B];
		ar << showClass[CLASS_A];
		ar << showClass[CLASS_F];
		ar << showClass[CLASS_G];
		ar << showClass[CLASS_K];
		ar << showClass[CLASS_M];
		ar << showClass[CLASS_X];
		ar << showBitmapStars;
		ar << scaleFactor[SCALE_3D];
		ar << scaleFactor[SCALE_NO_3D];
		ar << scaleMode;
		ar << (DWORD)currentBackgroundColor;
		ar << (DWORD)currentLineColor;
		ar << (DWORD)currentNameColor;
		ar << (DWORD)currentCoordColor;
		ar << (DWORD)currentAltLineColor;
		ar << (DWORD)spectralColor[CLASS_O];
		ar << (DWORD)spectralColor[CLASS_B];
		ar << (DWORD)spectralColor[CLASS_A];
		ar << (DWORD)spectralColor[CLASS_F];
		ar << (DWORD)spectralColor[CLASS_G];
		ar << (DWORD)spectralColor[CLASS_K];
		ar << (DWORD)spectralColor[CLASS_M];
		ar << (DWORD)spectralColor[CLASS_X];
		ar << (DWORD)currentPlaneColor[XY];
		ar << (DWORD)currentPlaneColor[XZ];
		ar << (DWORD)currentPlaneColor[YZ];
		ar << (DWORD)currentAxisColor;
		nameFont->Serialize(ar);
		coordFont->Serialize(ar);
		ar << showDecimalCoord;
		ar << distanceFilterLimit;
		ar << distanceFilter;
		ar << perspectiveEngine->thetaDegrees;
		ar << perspectiveEngine->phiDegrees;
		ar << perspectiveEngine->rhoValue;
		ar << perspectiveEngine->origin.x;
		ar << perspectiveEngine->origin.y;
		ar << perspectiveEngine->origin.z;
		ar << perspectiveEngine->separation;
		ar << perspectiveEngine->viewAngleDegrees;
		for (a = 0; a < NUM_LINE_TYPES; a++)
			lines[a].Serialize(ar);
	}
	else
	{
		ar >> viewMode;
		ar >> showNames;
		ar >> showLines;
		ar >> lineLimit;
		ar >> showLine[LIMIT_LINE];
		ar >> showLine[CLOSEST_LINE];
		ar >> showLine[CUSTOM_LINE];
		ar >> showXYZAxis;
		ar >> showPlane[XY];
		ar >> showPlane[XZ];
		ar >> showPlane[YZ];
		ar >> showLineAlt[XY];
		ar >> showLineAlt[XZ];
		ar >> showLineAlt[YZ];
		ar >> showLineShadow;
		ar >> showRadials;
		ar >> showCoords;
		ar >> coordType;
		ar >> showClass[CLASS_O];
		ar >> showClass[CLASS_B];
		ar >> showClass[CLASS_A];
		ar >> showClass[CLASS_F];
		ar >> showClass[CLASS_G];
		ar >> showClass[CLASS_K];
		ar >> showClass[CLASS_M];
		ar >> showClass[CLASS_X];
		ar >> showBitmapStars;
		ar >> scaleFactor[SCALE_3D];
		ar >> scaleFactor[SCALE_NO_3D];
		ar >> scaleMode;
		ar >> theColor;		currentBackgroundColor =	(COLORREF)theColor;
		ar >> theColor;		currentLineColor =			(COLORREF)theColor;
		ar >> theColor;		currentNameColor =			(COLORREF)theColor;
		ar >> theColor;		currentCoordColor =			(COLORREF)theColor;
		ar >> theColor;		currentAltLineColor =		(COLORREF)theColor;
		ar >> theColor;		spectralColor[CLASS_O] =	(COLORREF)theColor;
		ar >> theColor;		spectralColor[CLASS_B] =	(COLORREF)theColor;
		ar >> theColor;		spectralColor[CLASS_A] =	(COLORREF)theColor;
		ar >> theColor;		spectralColor[CLASS_F] =	(COLORREF)theColor;
		ar >> theColor;		spectralColor[CLASS_G] =	(COLORREF)theColor;
		ar >> theColor;		spectralColor[CLASS_K] =	(COLORREF)theColor;
		ar >> theColor;		spectralColor[CLASS_M] =	(COLORREF)theColor;
		ar >> theColor;		spectralColor[CLASS_X] =	(COLORREF)theColor;
		ar >> theColor;		currentPlaneColor[XY] =		(COLORREF)theColor;
		ar >> theColor;		currentPlaneColor[XZ] =		(COLORREF)theColor;
		ar >> theColor;		currentPlaneColor[YZ] =		(COLORREF)theColor;
		ar >> theColor;		currentAxisColor =			(COLORREF)theColor;
		nameFont->Serialize(ar);
		coordFont->Serialize(ar);
		ar >> showDecimalCoord;
		ar >> distanceFilterLimit;
		ar >> distanceFilter;
		ar >> dValue;
		perspectiveEngine->setTheta(dValue);
		ar >> dValue;
		perspectiveEngine->setPhi(dValue);
		ar >> dValue;
		perspectiveEngine->setRho(dValue);
		ar >> perspectiveEngine->origin.x;
		ar >> perspectiveEngine->origin.y;
		ar >> perspectiveEngine->origin.z;
		ar >> dValue;
		perspectiveEngine->setEyeSeparation(dValue);
		ar >> dValue;
		perspectiveEngine->setViewAngle(dValue);
		for (a = 0; a < NUM_LINE_TYPES; a++)
			lines[a].Serialize(ar);


		theMainFrame = (CMainFrame *)GetParent();
		if (theMainFrame != NULL)
		{
			theMainFrame->m_Spin_Theta_Ctrl.SetPos(perspectiveEngine->thetaDegrees);
			theMainFrame->m_Spin_Phi_Ctrl.SetPos(perspectiveEngine->phiDegrees);
			theMainFrame->m_Spin_Rho_Ctrl.SetPos(perspectiveEngine->rhoValue);
			theMainFrame->m_Spin_Scale_Ctrl.SetPos(scaleFactor[scaleMode]);
			theMainFrame->m_Spin_ViewAngle_Ctrl.SetPos(perspectiveEngine->viewAngleDegrees);
			theMainFrame->m_Spin_EyeSep_Ctrl.SetPos(perspectiveEngine->separation * 10.0);
		}

		GetAxis();
		CalcEye();
		ConfigureScrolling();	
		if (NO3D == viewMode)
			InitializeNameRects();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::GetAxis()
{
	for (int a = 0; a < NUMCOORDSYSTEMS; a++)
	{
		axisCoords[AXISX][PLUSAXIS][a].x = theDoc->plane[XY][LOWERRIGHT][a].x;
		axisCoords[AXISX][PLUSAXIS][a].y = 0.0 + perspectiveEngine->origin.y;
		axisCoords[AXISX][PLUSAXIS][a].z = 0.0 + perspectiveEngine->origin.z;

		axisCoords[AXISX][MINUSAXIS][a].x = theDoc->plane[XY][UPPERLEFT][a].x;
		axisCoords[AXISX][MINUSAXIS][a].y = 0.0 + perspectiveEngine->origin.y;
		axisCoords[AXISX][MINUSAXIS][a].z = 0.0 + perspectiveEngine->origin.z;

		axisCoords[AXISY][PLUSAXIS][a].x = 0.0 + perspectiveEngine->origin.x;
		axisCoords[AXISY][PLUSAXIS][a].y = theDoc->plane[XY][UPPERLEFT][a].y;
		axisCoords[AXISY][PLUSAXIS][a].z = 0.0 + perspectiveEngine->origin.z;

		axisCoords[AXISY][MINUSAXIS][a].x = 0.0 + perspectiveEngine->origin.x;
		axisCoords[AXISY][MINUSAXIS][a].y = theDoc->plane[XY][LOWERRIGHT][a].y;
		axisCoords[AXISY][MINUSAXIS][a].z = 0.0 + perspectiveEngine->origin.z;

		axisCoords[AXISZ][PLUSAXIS][a].x = 0.0 + perspectiveEngine->origin.x;
		axisCoords[AXISZ][PLUSAXIS][a].y = 0.0 + perspectiveEngine->origin.y;
		axisCoords[AXISZ][PLUSAXIS][a].z = theDoc->plane[XZ][UPPERLEFT][a].z;

		axisCoords[AXISZ][MINUSAXIS][a].x = 0.0 + perspectiveEngine->origin.x;
		axisCoords[AXISZ][MINUSAXIS][a].y = 0.0 + perspectiveEngine->origin.y;
		axisCoords[AXISZ][MINUSAXIS][a].z = theDoc->plane[XZ][LOWERRIGHT][a].z;
	}
}

/***************************************************************************/
void CStereoStarView::CalcOriginDist()
{
	int			numStars = theDoc->GetNumStars();
	TriPoint	theLoc;

	for (int starNum = 0; starNum < numStars; starNum++)
	{
		theLoc = theDoc->GetLoc(starNum, coordType);
		theDoc->SetOriginDist(starNum, TrueDistance(&theLoc, &(perspectiveEngine->origin)));
	}
}

/***************************************************************************/
void CStereoStarView::OnSetCoordOrigin() 
{
	CSetOriginDialog	dlg;

	dlg.pDoc = theDoc;
	dlg.m_Origin_X = perspectiveEngine->origin.x;
	dlg.m_Origin_Y = perspectiveEngine->origin.y;
	dlg.m_Origin_Z = perspectiveEngine->origin.z;
	dlg.coordType = coordType;
	if  (dlg.DoModal() == IDOK)
	{
		perspectiveEngine->origin.x = dlg.m_Origin_X;
		perspectiveEngine->origin.y = dlg.m_Origin_Y;
		perspectiveEngine->origin.z = dlg.m_Origin_Z;
		CalcOriginDist();
		GetAxis();
//		CalcLine();
		CalcEye();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnSetFilterDistance() 
{
	CSetOriginDistanceDialog	dlg;

	dlg.m_Max_Origin_Distance = distanceFilterLimit;
	if  (dlg.DoModal() == IDOK)
	{
		distanceFilterLimit = dlg.m_Max_Origin_Distance;
		theApp.WriteProfileInt("Settings", DISTANCE_FILTER_LIMIT_KEY,	distanceFilterLimit * 10);
		CalcOriginDist();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
BOOL CStereoStarView::StarVisible(short starNum)
{
	BOOL	isVisible = TRUE;
	short	spectralClass = theDoc->GetSpectralClass(starNum);


	if (!showClass[spectralClass])
		isVisible = FALSE;

	if (distanceFilter && (theDoc->GetOriginDist(starNum) > distanceFilterLimit))
		isVisible = FALSE;

	return isVisible;
}
// end CStereoStarView::StarVisible

/***************************************************************************/
void CStereoStarView::ChangeScrollSize(CSize newSize)
{
	CSize	actualNewSize = newSize;
	CSize	theDocSize = GetDocument()->GetDocSize(coordType);
	BOOL	goodSize = FALSE;

	if (offscreenDCInit)
	{
		if (offscreenBitMap != NULL)
		{
			offscreenDC.SelectObject(pOldOffscreenBmp);
			delete offscreenBitMap;
			offscreenBitMap = NULL;
		}

		CDC*	dc = GetDC();

		offscreenBitMap = new CBitmap;

		if (viewMode == NO3D)
		{
			while (!goodSize)
			{
#ifdef OLD
				if (offscreenBitMap->CreateBitmap(actualNewSize.cx, actualNewSize.cy, 1, 8, NULL))
#else
				if (offscreenBitMap->CreateCompatibleBitmap(dc, actualNewSize.cx, actualNewSize.cy))
#endif
				{
					offscreenDC.SelectObject(offscreenBitMap);
					offscreenDC.SelectClipRgn(NULL);	// going to, say, cross-eye mode then no3D mode screws up
														// the clipping region. This resets it.
					offscreenRect.SetRect(0,0,actualNewSize.cx, actualNewSize.cy);
					goodSize = TRUE;
				}
				else	// bitmap is too big to fit into available memory
				{		// keep reducing the scale until it fits into memory
					if (scaleFactor[scaleMode] > 10)	scaleFactor[scaleMode] -= 10;
					else								scaleFactor[scaleMode] -= 1;
					if (scaleFactor[scaleMode] < 1)
					{
						::AfxMessageBox("Not enough memory to create bitmap!", MB_OK | MB_ICONEXCLAMATION);
						exit(0);
					}
					actualNewSize.cx = theDocSize.cx * scaleFactor[scaleMode];
					actualNewSize.cy = theDocSize.cy * scaleFactor[scaleMode];
					theMainFrame->m_Spin_Scale_Ctrl.SetPos(scaleFactor[scaleMode]);
				}
			}
		}
		else
		{
			if (offscreenBitMap->CreateCompatibleBitmap(dc, newSize.cx, newSize.cy))
			{
				offscreenDC.SelectObject(offscreenBitMap);
				offscreenDC.SelectClipRgn(NULL);	// going to, say, cross-eye mode then no3D mode screws up
													// the clipping region. This resets it.
				offscreenRect.SetRect(0,0,newSize.cx, newSize.cy);
				goodSize = TRUE;
			}
			else
			{
				::AfxMessageBox("Not enough memory to create bitmap!", MB_OK | MB_ICONEXCLAMATION);
				exit(0);
			}
		}

		SetScrollSizes( MM_TEXT, actualNewSize );
		ChangeScreenDimensions(actualNewSize.cx, actualNewSize.cy);
		UpdateOffscreenBitmap();
	}
	else
	{
		SetScrollSizes( MM_TEXT, actualNewSize );
		ChangeScreenDimensions(actualNewSize.cx, actualNewSize.cy);
	}
}
// end CStereoStarView::ChangeScrollSize

/***************************************************************************/
void CStereoStarView::SetScrollToDocSize()
{
	CSize	theDocSize = GetDocument()->GetDocSize(coordType);

	theDocSize.cx *= scaleFactor[scaleMode];
	theDocSize.cy *= scaleFactor[scaleMode];

	ChangeScrollSize(theDocSize);
}
// end CStereoStarView::SetScrollToDocSize

/***************************************************************************/
void CStereoStarView::SetScrollToScreenSize()
{
	CSize		theScreenSize, theScrollBarSize;

	GetTrueClientSize(theScreenSize, theScrollBarSize);
	ChangeScrollSize(theScreenSize);
}
// end CStereoStarView::SetScrollToScreenSize

/***************************************************************************/
void CStereoStarView::ConfigureScrolling()
{
	if (viewMode == NO3D)	
		SetScrollToDocSize();
	else					
		SetScrollToScreenSize();
}
// end CStereoStarView::ConfigureScrolling

/***************************************************************************/
BOOL CStereoStarView::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}
// end CStereoStarView::OnEraseBkgnd

/***************************************************************************/
void CStereoStarView::OnSpinscalePressed()
{
	showNamesCache = showNames;
	showNames = FALSE;
	showLinesCache = showLines;
	showLines = FALSE;
	showCoordsCache = showCoords;
	showCoords = FALSE;
}
// end CStereoStarView::OnSpinscalePressed

/***************************************************************************/
void CStereoStarView::OnSpinscaleUnpressed()
{
	showNames = showNamesCache;
	showLines = showLinesCache;
	showCoords = showCoordsCache;
}
// end CStereoStarView::OnSpinscaleUnpressed

/***************************************************************************/
void CStereoStarView::PlotAxisNo3D(CPaintDC* dc)
{
	double		a, b;
	char		buffer[10];
	CFont*		oldFont;
	UINT		oldAlign;
	COLORREF	oldBkColor;

	// draw main axis
	DrawLine(dc, ScaleX(0.0), ScaleY(axisCoords[AXISY][PLUSAXIS][coordType].y), 
		 ScaleX(0.0), ScaleY(axisCoords[AXISY][MINUSAXIS][coordType].y), currentAxisColor);
	DrawLine(dc, ScaleX(axisCoords[AXISX][MINUSAXIS][coordType].x), ScaleY(0.0), 
		 ScaleX(axisCoords[AXISX][PLUSAXIS][coordType].x), ScaleY(0.0), currentAxisColor);

	//   draw x-axis full co-ord tick marks
	for (a = 0.0; a <= axisCoords[AXISX][PLUSAXIS][coordType].x; a += 1.0)
	{
		DrawLine(dc, ScaleX(a), ScaleY(-0.1), 
			 ScaleX(a), ScaleY(0.1), currentAxisColor);
	}
	for (b = 0.0; b >=  axisCoords[AXISX][MINUSAXIS][coordType].x; b -= 1.0)
	{
		DrawLine(dc, ScaleX(b), ScaleY(-0.1), 
			 ScaleX(b), ScaleY(0.1), currentAxisColor);
	}

	//   draw x-axis half co-ord tick marks
	for (a = 0.0; a <= axisCoords[AXISX][PLUSAXIS][coordType].x; a += 0.5)
	{
		DrawLine(dc, ScaleX(a), ScaleY(-0.05), 
			 ScaleX(a), ScaleY(0.05), currentAxisColor);
	}
	for (b = 0.0; b >=  axisCoords[AXISX][MINUSAXIS][coordType].x; b -= 0.5)
	{
		DrawLine(dc, ScaleX(b), ScaleY(-0.05), 
			 ScaleX(b), ScaleY(0.05), currentAxisColor);
	}

	//   draw y-axis full tick marks
	for (a = 0.0; a <= axisCoords[AXISY][PLUSAXIS][coordType].y; a += 1.0)
	{
		DrawLine(dc, ScaleX(-0.1), ScaleY(a), 
			 ScaleX(0.1), ScaleY(a), currentAxisColor);
	}
	for (b = 0.0; b >= axisCoords[AXISY][MINUSAXIS][coordType].y; b -= 1.0)
	{
		DrawLine(dc, ScaleX(-0.1), ScaleY(b), 
			 ScaleX(0.1), ScaleY(b), currentAxisColor);
	}

	//   draw y-axis half tick marks
	for (a = 0.0; a <= axisCoords[AXISY][PLUSAXIS][coordType].y; a += 0.5)
	{
		DrawLine(dc, ScaleX(-0.05), ScaleY(a), 
			 ScaleX(0.05), ScaleY(a), currentAxisColor);
	}
	for (b = 0.0; b >= axisCoords[AXISY][MINUSAXIS][coordType].y; b -= 0.5)
	{
		DrawLine(dc, ScaleX(-0.05), ScaleY(b), 
			 ScaleX(0.05), ScaleY(b), currentAxisColor);
	}

	// draw X and Y labels
	oldFont = dc->SelectObject(coordFont);
	oldAlign = dc->SetTextAlign(TA_CENTER | TA_BASELINE);
	dc->SetBkMode(OPAQUE);
	dc->SetTextColor(currentAxisColor);
	oldBkColor = dc->SetBkColor(currentBackgroundColor);

	sprintf(buffer,"+X");
	dc->SetTextAlign(TA_LEFT | TA_BASELINE);
	dc->TextOut(ScaleX(axisCoords[AXISX][PLUSAXIS][coordType].x) + 10, ScaleY(0.0), buffer, lstrlen(buffer));

	sprintf(buffer,"-X");
	dc->SetTextAlign(TA_RIGHT | TA_BASELINE);
	dc->TextOut(ScaleX(axisCoords[AXISX][MINUSAXIS][coordType].x) - 10, ScaleY(0.0), buffer, lstrlen(buffer));

	sprintf(buffer,"+Y");
	dc->SetTextAlign(TA_CENTER | TA_BOTTOM);
	dc->TextOut(ScaleX(0.0), ScaleY(axisCoords[AXISY][PLUSAXIS][coordType].y) -10, buffer, lstrlen(buffer));

	sprintf(buffer,"-Y");
	dc->SetTextAlign(TA_CENTER | TA_TOP);
	dc->TextOut(ScaleX(0.0), ScaleY(axisCoords[AXISY][MINUSAXIS][coordType].y) +10, buffer, lstrlen(buffer));

	dc->SetBkColor(oldBkColor);
	dc->SetTextColor(BLACKCOLOR);
	dc->SelectObject(oldFont);
	dc->SetTextAlign(oldAlign);
}
// end CStereoStarView::PlotAxisNo3D

/***************************************************************************/
void CStereoStarView::PlotGridNo3D(CPaintDC* dc)
{
	double		a, b;
	CFont*		oldFont;
	UINT		oldAlign;
	COLORREF	oldBkColor;
	char		buffer[10];
	CPen*		oldPen;
	CPen		newPen;

	newPen.CreatePen(PS_DOT, 0, currentAltLineColor);
	oldPen = dc->SelectObject(&newPen);

	//   draw vertical half co-ord lines
	for (a = 0.0; a <= axisCoords[AXISX][PLUSAXIS][coordType].x; a += 0.5)
	{
		dc->MoveTo(ScaleX(a), ScaleY(axisCoords[AXISY][PLUSAXIS][coordType].y));
		dc->LineTo(ScaleX(a), ScaleY(axisCoords[AXISY][MINUSAXIS][coordType].y));
	}
	for (b = 0.0; b >= axisCoords[AXISX][MINUSAXIS][coordType].x; b -= 0.5)
	{
		dc->MoveTo(ScaleX(b), ScaleY(axisCoords[AXISY][PLUSAXIS][coordType].y)); 
		dc->LineTo(ScaleX(b), ScaleY(axisCoords[AXISY][MINUSAXIS][coordType].y));
	}

	//   draw horizontal half co-ord lines
	for (a = 0.0; a <= axisCoords[AXISY][PLUSAXIS][coordType].y; a += 0.5)
	{
		dc->MoveTo(ScaleX(axisCoords[AXISX][MINUSAXIS][coordType].x), ScaleY(a)); 
		dc->LineTo(ScaleX(axisCoords[AXISX][PLUSAXIS][coordType].x), ScaleY(a));
	}
	for (b = 0.0; b >= axisCoords[AXISY][MINUSAXIS][coordType].y; b -= 0.5)
	{
		dc->MoveTo(ScaleX(axisCoords[AXISX][MINUSAXIS][coordType].x), ScaleY(b)); 
		dc->LineTo(ScaleX(axisCoords[AXISX][PLUSAXIS][coordType].x), ScaleY(b));
	}

	dc->SelectObject(oldPen);

	//   draw vertical full co-ord lines
	for (a = 0.0; a <= axisCoords[AXISX][PLUSAXIS][coordType].x; a += 1.0)
	{
		DrawLine(dc, ScaleX(a), ScaleY(axisCoords[AXISY][PLUSAXIS][coordType].y), 
			 ScaleX(a), ScaleY(axisCoords[AXISY][MINUSAXIS][coordType].y), currentAltLineColor);
	}
	for (b = 0.0; b >=  axisCoords[AXISX][MINUSAXIS][coordType].x; b -= 1.0)
	{
		DrawLine(dc, ScaleX(b), ScaleY(axisCoords[AXISY][PLUSAXIS][coordType].y), 
			 ScaleX(b), ScaleY(axisCoords[AXISY][MINUSAXIS][coordType].y), currentAltLineColor);
	}

	//   draw horizontal full co-ord lines
	for (a = 0.0; a <= axisCoords[AXISY][PLUSAXIS][coordType].y; a += 1.0)
	{
		DrawLine(dc, ScaleX(axisCoords[AXISX][MINUSAXIS][coordType].x), ScaleY(a), 
			 ScaleX(axisCoords[AXISX][PLUSAXIS][coordType].x), ScaleY(a), currentAltLineColor);
	}
	for (b = 0.0; b >= axisCoords[AXISY][MINUSAXIS][coordType].y; b -= 1.0)
	{
		DrawLine(dc, ScaleX(axisCoords[AXISX][MINUSAXIS][coordType].x), ScaleY(b), 
			 ScaleX(axisCoords[AXISX][PLUSAXIS][coordType].x), ScaleY(b), currentAltLineColor);
	}

	// draw center axis
	if (showXYZAxis)
	{
		DrawLine(dc, ScaleX(0.0), ScaleY(axisCoords[AXISY][PLUSAXIS][coordType].y), 
			 ScaleX(0.0), ScaleY(axisCoords[AXISY][MINUSAXIS][coordType].y), currentAxisColor);
		DrawLine(dc, ScaleX(axisCoords[AXISX][MINUSAXIS][coordType].x), ScaleY(0.0), 
			 ScaleX(axisCoords[AXISX][PLUSAXIS][coordType].x), ScaleY(0.0), currentAxisColor);
	}

	// draw numbers on axis
	oldFont = dc->SelectObject(coordFont);
	oldAlign = dc->SetTextAlign(TA_CENTER | TA_BASELINE);
	dc->SetBkMode(OPAQUE);
	dc->SetTextColor(currentAltLineColor);
	oldBkColor = dc->SetBkColor(currentBackgroundColor);

	for (a = 1.0; a <= axisCoords[AXISX][PLUSAXIS][coordType].x; a += 1.0)
	{
		sprintf(buffer,"%3.1f", a);
		dc->TextOut(ScaleX(a), ScaleY(0.0), buffer, lstrlen(buffer));
	}
	for (b = -1.0; b >= axisCoords[AXISX][MINUSAXIS][coordType].x; b -= 1.0)
	{
		sprintf(buffer,"%3.1f", b);
		dc->TextOut(ScaleX(b), ScaleY(0.0), buffer, lstrlen(buffer));
	}

	for (a = 1.0; a <= axisCoords[AXISY][PLUSAXIS][coordType].y; a += 1.0)
	{
		sprintf(buffer,"%3.1f", a);
		dc->TextOut(ScaleX(0.0), ScaleY(a), buffer, lstrlen(buffer));
	}
	for (b = -1.0; b >= axisCoords[AXISY][MINUSAXIS][coordType].y; b -= 1.0)
	{
		sprintf(buffer,"%3.1f", b);
		dc->TextOut(ScaleX(0.0), ScaleY(b), buffer, lstrlen(buffer));
	}

	dc->SetBkColor(oldBkColor);
	dc->SetTextColor(BLACKCOLOR);
	dc->SelectObject(oldFont);
	dc->SetTextAlign(oldAlign);
}
// end CStereoStarView::PlotGridNo3D

/***************************************************************************/
void CStereoStarView::OnLabelLineLengths() 
{
	labelLineLength = !labelLineLength;
	theApp.WriteProfileInt("Settings", LABEL_LINE_LENGTH_KEY,	labelLineLength);
	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}
// end CStereoStarView::OnLabelLineLengths

/***************************************************************************/
void CStereoStarView::OnUpdateLabelLineLengths(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(labelLineLength);
}
// end CStereoStarView::OnUpdateLabelLineLengths

/***************************************************************************/
void CStereoStarView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{

	// allow the base class do its job
	CScrollView::OnPrepareDC(pDC, pInfo);

	// ## insert code to do print time pagination
	// pInfo->m_nCurPage specifies which page
	// change viewport origin and clipping region to print appropriate page
	// pDC->SetViewportOrg(x,y);
	// if length of document not specified, check for end of document

	if (pInfo)     // are we printing/print previewing?
	{
		pDC->SetMapMode(MM_ANISOTROPIC);

		// printer viewports typically have 300 pixels per inch
		pDC->SetViewportExt(pDC->GetDeviceCaps(LOGPIXELSX),pDC->GetDeviceCaps(LOGPIXELSY));

		CSize szDisplayCap(96,96);

		HDC hDC = ::GetDC(NULL);
		if (hDC)
		{
		   szDisplayCap.cx = ::GetDeviceCaps(hDC,LOGPIXELSX);
		   szDisplayCap.cy = ::GetDeviceCaps(hDC,LOGPIXELSY);
		   ::ReleaseDC(NULL,hDC);
		}

		// computer monitor displays typically have 96 pixels per inch (at least in Windows 95)
		pDC->SetWindowExt(szDisplayCap);

		// do pagination
		short	theLeft;
		short	theTop;
		double	intermediate;

		if (pInfo->m_nCurPage <= pagesWide)	
			theLeft = (pInfo->m_nCurPage - 1) * printHorzRes;
		else								
			theLeft = ( (pInfo->m_nCurPage - 1) % pagesWide ) * printHorzRes;

		intermediate = (pInfo->m_nCurPage-1) / pagesWide;
		theTop = floor( intermediate ) * printVertRes;

		pDC->SetViewportOrg(-theLeft, -theTop);
		TRACE("PAGE #%d: theLeft = %d,  theTop = %d\n", pInfo->m_nCurPage, theLeft, -theTop);
	}
}
// end CStereoStarView::OnPrepareDC

/***************************************************************************/
// TransparentBlt       - Copies a bitmap transparently onto the destination DC
// hdcDest              - Handle to destination device context
// nXDest               - x-coordinate of destination rectangle's upper-left corner
// nYDest               - y-coordinate of destination rectangle's upper-left corner
// nWidth               - Width of destination rectangle
// nHeight              - height of destination rectangle
// hBitmap              - Handle of the source bitmap
// nXSrc                - x-coordinate of source rectangle's upper-left corner
// nYSrc                - y-coordinate of source rectangle's upper-left corner
// colorTransparent     - The transparent color
// hPal                 - Logical palette to be used with bitmap. Can be NULL
/***************************************************************************/
void CStereoStarView::TransparentBlt(HDC hdcDest, int nXDest, int nYDest, int nWidth, int nHeight, 
									 HBITMAP hBitmap, int nXSrc, int nYSrc, COLORREF colorTransparent, HPALETTE hPal)
{
	CDC dc, memDC, maskDC, tempDC;
	dc.Attach( hdcDest );
	maskDC.CreateCompatibleDC(&dc);
	CBitmap maskBitmap;

	//add these to store return of SelectObject() calls
	CBitmap* pOldMemBmp = NULL;
	CBitmap* pOldMaskBmp = NULL;
	HBITMAP hOldTempBmp = NULL;

	memDC.CreateCompatibleDC(&dc);
	tempDC.CreateCompatibleDC(&dc);
	CBitmap bmpImage;
	bmpImage.CreateCompatibleBitmap( &dc, nWidth, nHeight );
	pOldMemBmp = memDC.SelectObject( &bmpImage );

	// Select and realize the palette
	if( dc.GetDeviceCaps(RASTERCAPS) & RC_PALETTE && hPal )
	{
		::SelectPalette( dc, hPal, FALSE );		// FALSE so the exact palette is used
		dc.RealizePalette();

		::SelectPalette( memDC, hPal, FALSE );	// FALSE so the exact palette is used
	}

	hOldTempBmp = (HBITMAP) ::SelectObject( tempDC.m_hDC, hBitmap );

	memDC.BitBlt( 0,0,nWidth, nHeight, &tempDC, nXSrc, nYSrc, SRCCOPY );

	// Create monochrome bitmap for the mask
	maskBitmap.CreateBitmap( nWidth, nHeight, 1, 1, NULL );
	pOldMaskBmp = maskDC.SelectObject( &maskBitmap );
	memDC.SetBkColor( colorTransparent );

	// Create the mask from the memory DC
	maskDC.BitBlt( 0, 0, nWidth, nHeight, &memDC, 0, 0, SRCCOPY );

	// Set the background in memDC to black. Using SRCPAINT with black
	// and any other color results in the other color, thus making
	// black the transparent color
	memDC.SetBkColor(RGB(0,0,0));
	memDC.SetTextColor(RGB(255,255,255));
	memDC.BitBlt(0, 0, nWidth, nHeight, &maskDC, 0, 0, SRCAND);

	// Set the foreground to black. See comment above.
	dc.SetBkColor(RGB(255,255,255));
	dc.SetTextColor(RGB(0,0,0));
	dc.BitBlt(nXDest, nYDest, nWidth, nHeight, &maskDC, 0, 0, SRCAND);

	// Combine the foreground with the background
	dc.BitBlt(nXDest, nYDest, nWidth, nHeight, &memDC, 0, 0, SRCPAINT);


	if (hOldTempBmp)
		::SelectObject( tempDC.m_hDC, hOldTempBmp);
    if (pOldMaskBmp)
        maskDC.SelectObject( pOldMaskBmp );
    if (pOldMemBmp)
        memDC.SelectObject( pOldMemBmp );

    dc.Detach();

}
// end CStereoStarView::TransparentBlt

/***************************************************************************/
void CStereoStarView::OnLineWizard() 
{
#ifdef OLD
	CLineWizardDialog	dlg;
	CStarLine*			theStarLine;
	TriPoint			pointA;
	TriPoint			pointB;
	double				dist;
	int					xi, yi;
	int					numStars;
	int					hiStar;
	CUGCell				cell;
	int					a, b;

	dlg.theDoc = GetDocument();
	dlg.pNeighborLines = &(lines[CLOSEST_LINE]);
	dlg.pLimitLines = &(lines[LIMIT_LINE]);
	dlg.pCustomLines = &(lines[CUSTOM_LINE]);
	dlg.theView = this;

	if  (dlg.DoModal() == IDOK)
	{
		theApp.WriteProfileInt("Settings", LINE_LIMIT_KEY,	lineLimit * 10);

		EmptyLineList(CUSTOM_LINE);

		numStars = theDoc->GetNumStars();
		hiStar = numStars - 1;

		for (yi = 0; yi < numStars; yi++)
		{
			for (xi = 0; xi < numStars; xi++)
			{
					dlg.m_grid.GetCell(xi, yi, &cell);
					if (cell.GetCellType() == dlg.m_grid.checkboxIndex)
					{
						if (cell.GetNumber() == 1)
						{
							a = yi;
							b = hiStar - xi;
							pointA = theDoc->GetLoc(a, coordType);
							pointB = theDoc->GetLoc(b, coordType);
							dist = TrueDistance(&pointA, &pointB);
							theStarLine = new CStarLine(a, b, dist);
							lines[CUSTOM_LINE].AddTail(theStarLine);
						}
					}
			}
		}

		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
#endif
}
// end CStereoStarView::OnLineWizard

/***************************************************************************/
void CStereoStarView::OnUpdateLineWizard(CCmdUI* pCmdUI) 
{
#ifdef OLD
	if (!showLines)
		pCmdUI->SetCheck(2);	
	else
		pCmdUI->SetCheck(0);	
#else
		pCmdUI->SetCheck(2);	
#endif

}
// end CStereoStarView::OnUpdateLineWizard

/***************************************************************************/
void CStereoStarView::OnCustomizedLines() 
{
	showLine[CUSTOM_LINE] = !showLine[CUSTOM_LINE];
	theApp.WriteProfileInt("Settings", SHOW_CUSTOM_LINES_KEY,	showLine[CUSTOM_LINE]);

	UpdateOffscreenBitmap();
	InvalidateRect(theClientRect, TRUE);
}
// end CStereoStarView::OnCustomizedLines

/***************************************************************************/
void CStereoStarView::OnUpdateCustomizedLines(CCmdUI* pCmdUI) 
{
#ifdef OLD
	if (!showLines)
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(showLine[CUSTOM_LINE]);
#else
		pCmdUI->SetCheck(2);	
#endif
}
// end CStereoStarView::OnUpdateCustomizedLines

/***************************************************************************/
void CStereoStarView::OnUpdateSetTheLimit(CCmdUI* pCmdUI) 
{
	if (!showLines)
		pCmdUI->SetCheck(2);
	else
		pCmdUI->SetCheck(0);
}
// end CStereoStarView::OnUpdateSetTheLimit

/***************************************************************************/
void CStereoStarView::OnColorResetToDefault() 
{
	CResetColorDialog	dlg;	

	if  (dlg.DoModal() == IDOK)
	{
		SetDefaultColors();

		WriteColorToRegistry(spectralColor[CLASS_O], O_COLOR_KEY);
		WriteColorToRegistry(spectralColor[CLASS_B], B_COLOR_KEY);
		WriteColorToRegistry(spectralColor[CLASS_A], A_COLOR_KEY);
		WriteColorToRegistry(spectralColor[CLASS_F], F_COLOR_KEY);
		WriteColorToRegistry(spectralColor[CLASS_G], G_COLOR_KEY);
		WriteColorToRegistry(spectralColor[CLASS_K], K_COLOR_KEY);
		WriteColorToRegistry(spectralColor[CLASS_M], M_COLOR_KEY);
		WriteColorToRegistry(spectralColor[CLASS_X], X_COLOR_KEY);
		WriteColorToRegistry(currentLineColor, LINE_COLOR_KEY);
		WriteColorToRegistry(currentAltLineColor, ALT_COLOR_KEY);
		WriteColorToRegistry(currentPlaneColor[XY], PLANE_XY_COLOR_KEY);
		WriteColorToRegistry(currentPlaneColor[XZ], PLANE_XZ_COLOR_KEY);
		WriteColorToRegistry(currentPlaneColor[YZ], PLANE_YZ_COLOR_KEY);
		WriteColorToRegistry(currentNameColor, NAME_COLOR_KEY);
		WriteColorToRegistry(currentCoordColor, COORD_COLOR_KEY);
		WriteColorToRegistry(currentBackgroundColor, BG_COLOR_KEY);
		WriteColorToRegistry(currentAxisColor, AXIS_COLOR_KEY);

		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}
// end CStereoStarView::OnColorResetToDefault

/***************************************************************************/
void CStereoStarView::SetDefaultColors()
{
	spectralColor[CLASS_O] = O_DEFAULT_COLOR;
	spectralColor[CLASS_B] = B_DEFAULT_COLOR;
	spectralColor[CLASS_A] = A_DEFAULT_COLOR;
	spectralColor[CLASS_F] = F_DEFAULT_COLOR;
	spectralColor[CLASS_G] = G_DEFAULT_COLOR;
	spectralColor[CLASS_K] = K_DEFAULT_COLOR;
	spectralColor[CLASS_M] = M_DEFAULT_COLOR;
	spectralColor[CLASS_X] = X_DEFAULT_COLOR;

	currentLineColor = LINE_DEFAULT_COLOR;
	currentAltLineColor = ALT_DEFAULT_COLOR;
	currentPlaneColor[XY] = PLANE_XY_DEFAULT_COLOR;
	currentPlaneColor[XZ] = PLANE_XZ_DEFAULT_COLOR;
	currentPlaneColor[YZ] = PLANE_YZ_DEFAULT_COLOR;
	currentNameColor = NAME_DEFAULT_COLOR;
	currentCoordColor = COORD_DEFAULT_COLOR;
	currentBackgroundColor = BG_DEFAULT_COLOR;
	currentAxisColor = AXIS_DEFAULT_COLOR;
}
// end CStereoStarView::SetDefaultColors

/***************************************************************************/
void CStereoStarView::WriteColorToRegistry(COLORREF theColor, LPCTSTR theColorName)
{
	WORD	red		= GetRValue(theColor);
	WORD	green	= GetGValue(theColor);
	WORD	blue	= GetBValue(theColor);
	CString	redName(theColorName);
	CString	greenName(theColorName);
	CString	blueName(theColorName);

	redName		+= "R";
	greenName	+= "G";
	blueName	+= "B";

	theApp.WriteProfileInt("Color", redName,	red);
	theApp.WriteProfileInt("Color", greenName,	green);
	theApp.WriteProfileInt("Color", blueName,	blue);
}
// end CStereoStarView::WriteColorToRegistry

/***************************************************************************/
COLORREF CStereoStarView::ReadColorFromRegister(LPCTSTR theColorName, COLORREF defaultColor)
{
	WORD		red;
	WORD		green;
	WORD		blue;
	WORD		defaultRed	= GetRValue(defaultColor);
	WORD		defaultGreen= GetGValue(defaultColor);
	WORD		defaultBlue	= GetBValue(defaultColor);
	CString		redName(theColorName);
	CString		greenName(theColorName);
	CString		blueName(theColorName);
	COLORREF	theColor = defaultColor;

	redName		+= "R";
	greenName	+= "G";
	blueName	+= "B";

	red		= theApp.GetProfileInt("Color", redName,	defaultRed);
	green	= theApp.GetProfileInt("Color", greenName,	defaultGreen);
	blue	= theApp.GetProfileInt("Color", blueName,	defaultBlue);

	theColor = RGB(red, green, blue);

	return theColor;
}
// end CStereoStarView::ReadColorFromRegister

/***************************************************************************/
void CStereoStarView::OnFileLoadCustomLines() 
{
	CFileDialog browseOpenDialog(TRUE, "lin", NULL, OFN_PATHMUSTEXIST | OFN_HIDEREADONLY, 
								  "Line files (*.lin)|*.lin||", NULL);	

	if (browseOpenDialog.DoModal() == IDOK)
	{
		CProgressDialog	dlg;
		CStdioFile		datafile(browseOpenDialog.GetPathName(), CFile::modeRead);
		CString			inputBuffer;
		short			totalLines = 0;
		CStarLine*		theStarLine;
		CString			starA, starB;
		int				starAIndex, starBIndex;
		TriPoint		pointA, pointB;
		int				cleavagePoint;
		double			dist;
	
		EmptyLineList(CUSTOM_LINE);

		while (datafile.ReadString(inputBuffer))
			totalLines++;
		datafile.SeekToBegin();

		dlg.Create(IDD_PROGRESS_DIALOG, NULL);
		dlg.range = totalLines;
		dlg.labelText = "Loading Line #";

		while (datafile.ReadString(inputBuffer))
		{
			dlg.StepIt();

			cleavagePoint = inputBuffer.Find(',');
			starA = inputBuffer.Left(cleavagePoint);									// don't include trailing ','
			starB = inputBuffer.Right( inputBuffer.GetLength() - (cleavagePoint+1));	// dont' include preceeding ','
			starA.TrimLeft();
			starA.TrimRight();
			starB.TrimLeft();
			starB.TrimRight();

			starAIndex = theDoc->GetStarNum(starA);
			starBIndex = theDoc->GetStarNum(starB);
			if ((starAIndex != -1) && (starBIndex != -1))
			{
				pointA = theDoc->GetLoc(starAIndex, coordType);
				pointB = theDoc->GetLoc(starBIndex, coordType);
				dist = TrueDistance(&pointA, &pointB);
				theStarLine = new CStarLine(starAIndex, starBIndex, dist);
				lines[CUSTOM_LINE].AddTail(theStarLine);
			}
		}

		dlg.DestroyWindow();
		datafile.Close();
		UpdateOffscreenBitmap();
		InvalidateRect(theClientRect, TRUE);
	}
}

/***************************************************************************/
void CStereoStarView::OnFileSaveCustomLines() 
{
	CFileDialog browseOpenDialog(FALSE, "lin", NULL, OFN_CREATEPROMPT | OFN_OVERWRITEPROMPT| OFN_HIDEREADONLY, 
								  "Line files (*.lin)|*.lin||", NULL);	

	if (browseOpenDialog.DoModal() == IDOK)
	{
		CStdioFile		datafile(browseOpenDialog.GetPathName(), CFile::modeCreate | CFile::modeWrite);
		int				numLines = lines[CUSTOM_LINE].GetCount();
		CProgressDialog	dlg;
		CStarLine*		theStarLine;
		CString			outputBuffer;
		CString			starA, starB;

		dlg.Create(IDD_PROGRESS_DIALOG, NULL);
		dlg.range = numLines;
		dlg.labelText = "Saving Line #";

		for (int a = 0; a < numLines; a++) {
			theStarLine = (CStarLine*)lines[CUSTOM_LINE].GetAt(lines[CUSTOM_LINE].FindIndex(a));
			starA = theDoc->GetStarName(theStarLine->m_lStartStar);
			starB = theDoc->GetStarName(theStarLine->m_lEndStar);
			starA.TrimLeft();
			starA.TrimRight();
			starB.TrimLeft();
			starB.TrimRight();
			outputBuffer.Format("%s, %s\n",	starA, starB);
			datafile.WriteString(outputBuffer);
		}
		dlg.DestroyWindow();
		datafile.Close();
	}
}
