// StereoStarDoc.h : interface of the CStereoStarDoc class
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _CSTEREOSTARDOC
#define _CSTEREOSTARDOC
#include "StarDefs.h"

struct StarNode {
	CString		starName;
	TriPoint	loc[NUMCOORDSYSTEMS];
	short		spectralClass;
	double		originDist;	// distance to current origin
	RECT		nameRect;
	int			justification;
};


class CStereoStarDoc : public CDocument
{
protected: // create from serialization only
	void SaveViewFile(LPCTSTR lpszPathName);
	CStereoStarDoc();
	DECLARE_DYNCREATE(CStereoStarDoc)

// Attributes
public:
	void	SetOriginDist(short starNum, double newDist);
	double	GetOriginDist(short starNum);
	void	SetNameRect(short starNum, RECT* newRect, int newJustification);
	void	GetNameRect(short starNum, RECT* theRect, int* theJustification);

private:
	CPtrList		starList;
	CString			starFile;
	CSize			m_sizeDoc[NUMCOORDSYSTEMS];



// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CStereoStarDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual void OnCloseDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	int GetStarNum(CString theStarName);
	virtual ~CStereoStarDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	CSize		GetDocSize(short coordSystem);
	CString		GetStarName(short starNum);
	short		GetSpectralClass(short starNum);
	TriPoint	GetLoc(short starNum, short coordSystem);
	short		GetNumStars();
	TriPoint	plane[NUMPLANES][NUMCORNERS][NUMCOORDSYSTEMS];

private:
	void		EmptyStarList();

protected:

// Generated message map functions
protected:
	void LoadStarDataFile(LPCTSTR lpszPathName);
	void LoadViewFile(LPCTSTR lpszPathName);
	//{{AFX_MSG(CStereoStarDoc)
	afx_msg void OnFileLoadview();
	afx_msg void OnFileSaveview();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif