// StereoStar.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "StereoStar.h"

#include "MainFrm.h"
#include "StereoStarDoc.h"
#include "StereoStarView.h"
#include "StatLink.h"
#include "ModulVer.h"
#include "direct.h"
#include "Splash.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStereoStarApp

BEGIN_MESSAGE_MAP(CStereoStarApp, CWinApp)
	//{{AFX_MSG_MAP(CStereoStarApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStereoStarApp construction

CStereoStarApp::CStereoStarApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CStereoStarApp object

CStereoStarApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CStereoStarApp initialization

/***************************************************************************/
BOOL CStereoStarApp::InitInstance()
{
	// CG: The following block was added by the Splash Screen component.
//	{
//		CCommandLineInfo cmdInfo;
//		ParseCommandLine(cmdInfo);
//
//		CSplashWnd::EnableSplashScreen(cmdInfo.m_bShowSplash);
//	}

	// CG: The following line was added by the Splash Screen component.
//	CSplashWnd::ShowSplashScreen(NULL);

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	char	pBuf[_MAX_DIR];
	GetModuleFileName(NULL, pBuf, _MAX_DIR);
	appDir = pBuf;
	appDir = appDir.Left( appDir.ReverseFind('\\') );		// trim off the app name
	appName = pBuf;
	appName = appName.Right( appName.GetLength() - (appName.ReverseFind('\\') + 1) );	// trim off path

	SetRegistryKey("WinchWare");

	SetDocumentIcons();

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,					// ID of icon and document template string in String Table
		RUNTIME_CLASS(CStereoStarDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CStereoStarView));
	AddDocTemplate(pDocTemplate);

	CSingleDocTemplate* pViewTemplate;
	pViewTemplate = new CSingleDocTemplate(
		IDR_VEW_DOCUMENT,				// ID of icon and document template string in String Table
		RUNTIME_CLASS(CStereoStarDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CStereoStarView));
	AddDocTemplate(pViewTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	if (CCommandLineInfo::FileNew == cmdInfo.m_nShellCommand)
	{	// FileNew is not allowed, as this is a viewer program.
		// Force user to select a *.STR file to open
		CString				newName;
		if (DoPromptFileName(newName, AFX_IDS_OPENFILE,
			  OFN_HIDEREADONLY | OFN_FILEMUSTEXIST, TRUE, NULL))
		{
			cmdInfo.m_strFileName = newName;
			cmdInfo.m_nShellCommand = CCommandLineInfo::FileOpen;
		}
		else
			cmdInfo.m_nShellCommand = CCommandLineInfo::FileNothing;	// terminate
	}

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	return TRUE;
}
// end CStereoStarApp::InitInstance

/***************************************************************************/
// This function adds registry entries so that the *.str and *.vew
// files will display their icons.
/***************************************************************************/
void CStereoStarApp::SetDocumentIcons()
{
	HKEY		strKey;
	ULONG		theResult;
	CString		progID;
	HKEY		iconKey;
	HKEY		progKey;
	HKEY		cmdKey;
	HKEY		vewKey;
	CString		iconPath;
	CString		iconResource;
	CString		appFileName;
	CString		starFileExt(".str");
	CString		viewFileExt(".vew");
	CString		appExt(".exe");
	CString		theData;

	appFileName = appName;
	appFileName = appFileName.Left( appFileName.ReverseFind('.') );		// trim off the extension

	progID = appFileName + starFileExt;

	// Create *.str icon
	if (RegCreateKeyEx(HKEY_CLASSES_ROOT, starFileExt, 0, REG_NONE, REG_OPTION_NON_VOLATILE,
		KEY_WRITE, NULL, &strKey, &theResult ) == ERROR_SUCCESS)
	{
		RegSetValueEx(strKey, NULL, 0, REG_SZ, (CONST BYTE*)(LPCTSTR)progID, progID.GetLength());
		RegCloseKey(strKey);
	}
	if (RegCreateKeyEx(HKEY_CLASSES_ROOT, progID, 0, REG_NONE, REG_OPTION_NON_VOLATILE,
		KEY_WRITE, NULL, &progKey, &theResult) == ERROR_SUCCESS)
	{
		theData = "StereoStar star data file";
		RegSetValueEx( progKey, NULL, 0, REG_SZ, (CONST BYTE*)(LPCTSTR)theData, theData.GetLength() );
		if (RegCreateKeyEx(progKey, "DefaultIcon", 0, REG_NONE, REG_OPTION_NON_VOLATILE,
			KEY_WRITE, NULL, &iconKey, &theResult) == ERROR_SUCCESS)
		{
			iconPath = theApp.appDir + '\\' + appFileName + appExt;
			iconResource.Format(",-%d", IDR_STR_DOCUMENT);
			iconPath += iconResource;
			RegSetValueEx( iconKey, NULL, 0, REG_SZ, (CONST BYTE*)(LPCTSTR)iconPath, iconPath.GetLength() );
			RegCloseKey(iconKey);
		}

		if (RegCreateKeyEx(progKey, "shell\\open\\command", 0, REG_NONE, REG_OPTION_NON_VOLATILE,
			KEY_WRITE, NULL, &cmdKey, &theResult) == ERROR_SUCCESS)
		{
			theData = theApp.appDir + '\\' + appFileName + appExt + " %1";
			RegSetValueEx( cmdKey, NULL, 0, REG_SZ, (CONST BYTE*)(LPCTSTR)theData, theData.GetLength() );
			RegCloseKey(cmdKey);
		}

		RegCloseKey(progKey);
	}

	// Create *.vew icon
	progID = appFileName + viewFileExt;

	if (RegCreateKeyEx(HKEY_CLASSES_ROOT, viewFileExt, 0, REG_NONE, REG_OPTION_NON_VOLATILE,
		KEY_WRITE, NULL, &vewKey, &theResult ) == ERROR_SUCCESS)
	{
		RegSetValueEx( vewKey, NULL, 0, REG_SZ, (CONST BYTE*)(LPCTSTR)progID, progID.GetLength() );
		RegCloseKey(vewKey);
	}
 
	if (RegCreateKeyEx(HKEY_CLASSES_ROOT, progID, 0, REG_NONE, REG_OPTION_NON_VOLATILE,
		KEY_WRITE, NULL, &progKey, &theResult) == ERROR_SUCCESS)
	{
		theData = "StereoStar saved view file";
		RegSetValueEx( progKey, NULL, 0, REG_SZ, (CONST BYTE*)(LPCTSTR)theData, theData.GetLength() );
		if (RegCreateKeyEx(progKey, "DefaultIcon", 0, REG_NONE, REG_OPTION_NON_VOLATILE,
			KEY_WRITE, NULL, &iconKey, &theResult) == ERROR_SUCCESS)
		{
			iconPath = theApp.appDir + '\\' + appFileName + appExt; 
			iconResource.Format(",-%d", IDR_VEW_DOCUMENT);
			iconPath += iconResource;
			RegSetValueEx( iconKey, NULL, 0, REG_SZ, (CONST BYTE*)(LPCTSTR)iconPath, iconPath.GetLength() );
			RegCloseKey(iconKey);
		}

		if (RegCreateKeyEx(progKey, "shell\\open\\command", 0, REG_NONE, REG_OPTION_NON_VOLATILE,
			KEY_WRITE, NULL, &cmdKey, &theResult) == ERROR_SUCCESS)
		{
			theData = theApp.appDir + '\\' + appFileName + appExt + " %1";
			RegSetValueEx( cmdKey, NULL, 0, REG_SZ, (CONST BYTE*)(LPCTSTR)theData, theData.GetLength() );
			RegCloseKey(cmdKey);
		}

		RegCloseKey(progKey);
	}
}
// end CStereoStarApp::SetDocumentIcons

/***************************************************************************/
BOOL CStereoStarApp::PreTranslateMessage(MSG* pMsg)
{
	// CG: The following lines were added by the Splash Screen component.
	if (CSplashWnd::PreTranslateAppMessage(pMsg))
		return TRUE;

	return CWinApp::PreTranslateMessage(pMsg);
}
// end CStereoStarApp::PreTranslateMessage

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();
	CString	appName;

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CStatic	m_App_Copyright_Ctrl;
	CStatic	m_App_Name_Ctrl;
	CStaticLink	m_Static_URL_Ctrl;
	CStaticLink	m_Static_Email_Ctrl;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/***************************************************************************/
CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}
// end CAboutDlg::CAboutDlg

/***************************************************************************/
void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_STATIC_APPCOPYRIGHT, m_App_Copyright_Ctrl);
	DDX_Control(pDX, IDC_STATIC_APPNAME, m_App_Name_Ctrl);
	DDX_Control(pDX, IDC_STATIC_URL, m_Static_URL_Ctrl);
	DDX_Control(pDX, IDC_STATIC_EMAIL, m_Static_Email_Ctrl);
	//}}AFX_DATA_MAP
}
// end CAboutDlg::DoDataExchange

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStereoStarApp commands

/***************************************************************************/
BOOL CAboutDlg::OnInitDialog() 
{
	CModuleVersion	ver;

	m_Static_URL_Ctrl.SubclassDlgItem(IDC_STATIC_URL, this);
	m_Static_URL_Ctrl.m_link = _T("http://www.clark.net/pub/nyrath/starmap.html");
	m_Static_Email_Ctrl.SubclassDlgItem(IDC_STATIC_EMAIL, this);
	m_Static_Email_Ctrl.m_link = _T("mailto:nyrath@clark.net");

	CDialog::OnInitDialog();

	if (ver.GetFileVersionInfo(appName))
	{
		CString		titleString, copyrightString;

		titleString.Format("%s (Version %d.%d.%d.%d)",
			ver.GetValue(_T("ProductName")),
			HIWORD(ver.dwFileVersionMS),
			LOWORD(ver.dwFileVersionMS),
			HIWORD(ver.dwFileVersionLS),
			LOWORD(ver.dwFileVersionLS)
			);
		copyrightString.Format("%s %s",
			ver.GetValue(_T("LegalCopyright")),
			ver.GetValue(_T("CompanyName"))
			);
		m_App_Name_Ctrl.SetWindowText(titleString);
		m_App_Copyright_Ctrl.SetWindowText(copyrightString);
	}

	return TRUE;
}
// end CAboutDlg::OnInitDialog

/***************************************************************************/
// App command to run the dialog
void CStereoStarApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.appName = appName;
	aboutDlg.DoModal();
}
// end CStereoStarApp::OnAppAbout


