// SetOriginDialog.cpp : implementation file
//

#include "stdafx.h"
#include "StereoStar.h"
#include "SetOriginDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetOriginDialog dialog


CSetOriginDialog::CSetOriginDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSetOriginDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetOriginDialog)
	m_Origin_X = 0.0;
	m_Origin_Y = 0.0;
	m_Origin_Z = 0.0;
	//}}AFX_DATA_INIT
}


void CSetOriginDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetOriginDialog)
	DDX_Control(pDX, IDC_EDIT_ORIGIN_Z, m_Origin_Z_Ctrl);
	DDX_Control(pDX, IDC_EDIT_ORIGIN_Y, m_Origin_Y_Ctrl);
	DDX_Control(pDX, IDC_EDIT_ORIGIN_X, m_Origin_X_Ctrl);
	DDX_Control(pDX, IDC_COMBO_STAR_ORIGIN, m_Star_Origin_List_Ctrl);
	DDX_Text(pDX, IDC_EDIT_ORIGIN_X, m_Origin_X);
	DDX_Text(pDX, IDC_EDIT_ORIGIN_Y, m_Origin_Y);
	DDX_Text(pDX, IDC_EDIT_ORIGIN_Z, m_Origin_Z);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetOriginDialog, CDialog)
	//{{AFX_MSG_MAP(CSetOriginDialog)
	ON_BN_CLICKED(IDC_BUTTON_DEFAULT_ORIGIN, OnButtonDefaultOrigin)
	ON_CBN_SELCHANGE(IDC_COMBO_STAR_ORIGIN, OnSelchangeComboStarOrigin)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetOriginDialog message handlers

/***************************************************************************/
BOOL CSetOriginDialog::OnInitDialog() 
{
	CString	theName;
	int		nIndex;

	CDialog::OnInitDialog();
	
	int numStars = pDoc->GetNumStars();
	for (int a = 0; a < numStars; a++)
	{
		theName = pDoc->GetStarName(a);
		nIndex = m_Star_Origin_List_Ctrl.AddString(theName);
		m_Star_Origin_List_Ctrl.SetItemData (nIndex, a);
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/***************************************************************************/
void CSetOriginDialog::OnButtonDefaultOrigin() 
{
	SetOriginIndicator(0.0, 0.0, 0.0);
}

/***************************************************************************/
void CSetOriginDialog::SetOriginIndicator(double newX, double newY, double newZ)
{
	m_Origin_X = newX;
	m_Origin_Y = newY;
	m_Origin_Z = newZ;
	UpdateData(FALSE);	// xfer data from variables to controls
}

/***************************************************************************/
void CSetOriginDialog::OnSelchangeComboStarOrigin() 
{
	int			theSel;
	int			starNum;
	TriPoint	theLoc;

	theSel = m_Star_Origin_List_Ctrl.GetCurSel();
	if (theSel < 0)
		return;

	starNum = m_Star_Origin_List_Ctrl.GetItemData(theSel);
	theLoc = pDoc->GetLoc(starNum, coordType);
	SetOriginIndicator(theLoc.x, theLoc.y, theLoc.z);
}
