/*****************************************************************************
*
*	PerspectiveEngine.h : header file for CPerspectiveEngine class
*
*	Original programming:	Winchell Chung	10/20/1999
*	Changes:				
*
*=============== Copyright (C) 1999 Winchell D. Chung, Jr. ===============*/

#ifndef _CPERSPECTIVEENGINE_H_
#define _CPERSPECTIVEENGINE_H_
#include "StarDefs.h"

#define DEGREES_TO_RADIANS	0.017453293
#define ONE_EIGHTY  (180 * DEGREES_TO_RADIANS)	// in radians
#define THREE_SIXTY (360 * DEGREES_TO_RADIANS)	// in radians

/////////////////////////////////////////////////////////////////////////////
//	CPerspectiveEngine

class CPerspectiveEngine
{
// Operations
public:
	void initEye(int eyeID);
	void transformPoint(TriPoint* theLoc, double* ex, double* ey);
	void setTheta(double newThetaDegrees);
	void incrTheta();
	void decrTheta();
	void deltaTheta(BOOL isIncr);
	void setPhi(double newPhiDegrees);
	void incrPhi();
	void decrPhi();
	void deltaPhi(BOOL isIncr);
	void setRho(double newRho);
	void incrRho();
	void decrRho();
	void deltaRho(BOOL isIncr);
	void setViewAngle(double newAngle);
	void setEyeSeparation(double newSeparation);
// Constructors
public:
	CPerspectiveEngine(double initialTheta, double initialPhi, double initialRho);

// Destructors
public:
	virtual ~CPerspectiveEngine();

// Implementation
protected:
	double normalizeDegrees(double theDegrees);
	double ratchetDegrees(double initialDegrees, double ratchetValue);
	double mag(TriPoint *v);
	TriPoint subtract(TriPoint *v1, TriPoint *v2);
	TriPoint cross(TriPoint *v1, TriPoint *v2);
	TriPoint divide(TriPoint *v, double num);
	void polarToRectangular();


// Attributes
public:
	double		thetaDegrees;
	double		phiDegrees;
	double		rhoValue;
	TriPoint	origin;
	double		separation;
	double		viewAngleDegrees;
	TriPoint	center;
protected:
	double      thetaRadians;
	double		phiRadians;
	double		viewAngleRadians;
	TriPoint	aPrime;
	TriPoint	a1;
	TriPoint	a2;
	TriPoint	a3;
	TriPoint	temp;
	double		aPrimeMag;
	double      tempMag;
	double		offX;
	double		offY;
	double		offZ;
	TriPoint	from[NUMEYES];
	TriPoint	at;
	TriPoint	up;
	double		dval;

};

#endif // _CPERSPECTIVEENGINE_H_
