// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "StereoStar.h"

#include "MainFrm.h"
#include "StereoStarView.h"
#include "Splash.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_MODEBAR, OnViewModebar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_MODEBAR, OnUpdateViewModebar)
	ON_COMMAND(ID_VIEW_SHOWBAR, OnViewShowbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWBAR, OnUpdateViewShowbar)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
	ON_NOTIFY(WM_LBUTTONDOWN, IDC_SPIN_SCALE_TOOLBAR, OnSpinscalePressed)
	ON_NOTIFY(WM_LBUTTONUP, IDC_SPIN_SCALE_TOOLBAR, OnSpinscaleUnpressed)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_COORDTYPE,
	ID_INDICATOR_VIEWMODE,
	ID_INDICATOR_SCALEFACTOR,
	ID_INDICATOR_VIEWANGLE,
	ID_INDICATOR_EYESEPARATION,
	ID_INDICATOR_LINELIMIT,
	ID_INDICATOR_EYELOC,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

/***************************************************************************/
CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	m_Spin_Font = NULL;
}

/***************************************************************************/
CMainFrame::~CMainFrame()
{
	if (m_Spin_Font != NULL)
		delete m_Spin_Font;
}

/***************************************************************************/
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
#define SCALESLIDERINDEX	0

	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	/***********************************/
	/* Create and initialize cool menu */
	/***********************************/
	m_menuManager.Install(this);
	m_menuManager.LoadToolbar(IDR_MISCBAR);
	m_menuManager.LoadToolbar(IDR_SHOWBAR);
	m_menuManager.LoadToolbar(IDR_MAINFRAME);


	/**********************************/
	/* Create and initialize tool bar */
	/**********************************/
	if (!m_wndToolBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	// make room for spin controls on the toolbar
	CRect	spaceRect;
	CRect	theCtrlRect;

	// make the specified button into a separator, and widen it to 450 pixels
	m_wndToolBar.SetButtonInfo(SCALESLIDERINDEX, ID_SEPARATOR, TBBS_SEPARATOR, 450);	
	// get this separator's rectangle, to assist with placing the spin controls within it
	m_wndToolBar.GetItemRect(SCALESLIDERINDEX, spaceRect);

	// create spin control fonts
	m_Spin_Font = new(CFont);
	m_Spin_Font->CreatePointFont(80, "arial");

	/**************************************/
	/* add spin theta control to tool bar */
	/**************************************/

	spaceRect.left += 4;

	// add theta label
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 14;
	spaceRect.left += 14;
	theCtrlRect.DeflateRect(0,1);
	m_Spin_Theta_Label.Create(NULL, WS_CHILD | WS_VISIBLE | SS_CENTERIMAGE | SS_BITMAP, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_THETA_LABEL);
	m_Theta_Bitmap.LoadBitmap(IDB_THETA_LABEL);
	m_Spin_Theta_Label.SetBitmap((HBITMAP)m_Theta_Bitmap.m_hObject);

	// add theta value display
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 23;
	spaceRect.left += 23;
	theCtrlRect.DeflateRect(0,3);
	m_Spin_Theta_Value.Create("270", WS_CHILD | WS_VISIBLE | SS_RIGHT | SS_SUNKEN, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_THETA_VALUE);
	m_Spin_Theta_Value.SetFont(m_Spin_Font);

	// add theta spin button
	UDACCEL	accelTable[1];
	accelTable[0].nSec = 1;
	accelTable[0].nInc = 1;
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 22;
	spaceRect.left += 22;
	theCtrlRect.DeflateRect(0,2);
	m_Spin_Theta_Ctrl.Create(UDS_HORZ | UDS_WRAP | UDS_SETBUDDYINT | UDS_NOTHOUSANDS, 
							theCtrlRect, &m_wndToolBar, IDC_SPIN_THETA_TOOLBAR);
	m_Spin_Theta_Ctrl.SetBuddy(&m_Spin_Theta_Value);
	m_Spin_Theta_Ctrl.SetRange(0,359);
	m_Spin_Theta_Ctrl.SetPos(270);
	m_Spin_Theta_Ctrl.SetAccel(1,accelTable);
	m_Spin_Theta_Ctrl.ShowWindow(SW_SHOW);

	/************************************/
	/* add spin Phi control to tool bar */
	/************************************/

	spaceRect.left += 4;

	// add phi label
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 14;
	spaceRect.left += 14;
	theCtrlRect.DeflateRect(0,1);
	m_Spin_Phi_Label.Create(NULL, WS_CHILD | WS_VISIBLE | SS_CENTERIMAGE | SS_BITMAP, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_PHI_LABEL);
	m_Phi_Bitmap.LoadBitmap(IDB_PHI_LABEL);
	m_Spin_Phi_Label.SetBitmap((HBITMAP)m_Phi_Bitmap.m_hObject);

	// add phi value display
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 23;
	spaceRect.left += 23;
	theCtrlRect.DeflateRect(0,3);
	m_Spin_Phi_Value.Create("0", WS_CHILD | WS_VISIBLE | SS_RIGHT | SS_SUNKEN, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_PHI_VALUE);
	m_Spin_Phi_Value.SetFont(m_Spin_Font);

	// add phi spin button
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 26;
	spaceRect.left += 14;
	theCtrlRect.DeflateRect(0,2);
	m_Spin_Phi_Ctrl.Create(UDS_WRAP | UDS_SETBUDDYINT | UDS_NOTHOUSANDS, 
							theCtrlRect, &m_wndToolBar, IDC_SPIN_PHI_TOOLBAR);
	m_Spin_Phi_Ctrl.SetBuddy(&m_Spin_Phi_Value);
	m_Spin_Phi_Ctrl.SetRange(0,359);
	m_Spin_Phi_Ctrl.SetPos(0);
	m_Spin_Phi_Ctrl.SetAccel(1,accelTable);
	m_Spin_Phi_Ctrl.ShowWindow(SW_SHOW);

	/************************************/
	/* add spin Rho control to tool bar */
	/************************************/

	spaceRect.left += 4;

	// add rho label
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 14;
	spaceRect.left += 14;
	theCtrlRect.DeflateRect(0,1);
	m_Spin_Rho_Label.Create(NULL, WS_CHILD | WS_VISIBLE | SS_CENTERIMAGE | SS_BITMAP, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_RHO_LABEL);
	m_Rho_Bitmap.LoadBitmap(IDB_RHO_LABEL);
	m_Spin_Rho_Label.SetBitmap((HBITMAP)m_Rho_Bitmap.m_hObject);

	// add rho value display
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 23;
	spaceRect.left += 23;
	theCtrlRect.DeflateRect(0,3);
	m_Spin_Rho_Value.Create("6", WS_CHILD | WS_VISIBLE | SS_RIGHT | SS_SUNKEN, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_RHO_VALUE);
	m_Spin_Rho_Value.SetFont(m_Spin_Font);

	// add rho spin button
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 26;
	spaceRect.left += 14;
	theCtrlRect.DeflateRect(0,2);
	m_Spin_Rho_Ctrl.Create(UDS_SETBUDDYINT | UDS_NOTHOUSANDS, 
							theCtrlRect, &m_wndToolBar, IDC_SPIN_RHO_TOOLBAR);
	m_Spin_Rho_Ctrl.SetBuddy(&m_Spin_Rho_Value);
	m_Spin_Rho_Ctrl.SetRange(0,999);
	m_Spin_Rho_Ctrl.SetPos(6);
	m_Spin_Rho_Ctrl.SetAccel(1,accelTable);
	m_Spin_Rho_Ctrl.ShowWindow(SW_SHOW);

	/**************************************/
	/* add spin scale control to tool bar */
	/**************************************/

	spaceRect.left += 4;

	// add scale label
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 32;
	spaceRect.left += 32;
	theCtrlRect.DeflateRect(0,1);
	m_Spin_Scale_Label.Create(NULL, WS_CHILD | WS_VISIBLE | SS_CENTERIMAGE | SS_BITMAP, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_SCALE_LABEL);
	m_Scale_Bitmap.LoadBitmap(IDB_SCALE_LABEL);
	m_Spin_Scale_Label.SetBitmap((HBITMAP)m_Scale_Bitmap.m_hObject);

	// add scale value display
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 23;
	spaceRect.left += 23;
	theCtrlRect.DeflateRect(0,3);
	m_Spin_Scale_Value.Create("100", WS_CHILD | WS_VISIBLE | SS_RIGHT | SS_SUNKEN, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_SCALE_VALUE);
	m_Spin_Scale_Value.SetFont(m_Spin_Font);

	// add scale spin button
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 22;
	spaceRect.left += 14;
	theCtrlRect.DeflateRect(0,2);
	m_Spin_Scale_Ctrl.Create( UDS_SETBUDDYINT | UDS_NOTHOUSANDS, 
							theCtrlRect, &m_wndToolBar, IDC_SPIN_SCALE_TOOLBAR);
	m_Spin_Scale_Ctrl.SetBuddy(&m_Spin_Scale_Value);
	m_Spin_Scale_Ctrl.SetRange(0,999);
	m_Spin_Scale_Ctrl.SetPos(100);
	m_Spin_Scale_Ctrl.SetAccel(1,accelTable);
	m_Spin_Scale_Ctrl.ShowWindow(SW_SHOW);

	/*******************************************/
	/* add spin view angle control to tool bar */
	/*******************************************/

	spaceRect.left += 4;

	// add view angle label
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 61;
	spaceRect.left += 61;
	theCtrlRect.DeflateRect(0,1);
	m_Spin_ViewAngle_Label.Create(NULL, WS_CHILD | WS_VISIBLE | SS_CENTERIMAGE | SS_BITMAP, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_VIEWANGLE_LABEL);
	m_ViewAngle_Bitmap.LoadBitmap(IDB_VIEWANGLE_LABEL);
	m_Spin_ViewAngle_Label.SetBitmap((HBITMAP)m_ViewAngle_Bitmap.m_hObject);

	// add view angle value display
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 23;
	spaceRect.left += 23;
	theCtrlRect.DeflateRect(0,3);
	m_Spin_ViewAngle_Value.Create("45", WS_CHILD | WS_VISIBLE | SS_RIGHT | SS_SUNKEN, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_VIEWANGLE_VALUE);
	m_Spin_ViewAngle_Value.SetFont(m_Spin_Font);

	// add view angle spin button
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 22;
	spaceRect.left += 14;
	theCtrlRect.DeflateRect(0,2);
	m_Spin_ViewAngle_Ctrl.Create( UDS_WRAP | UDS_SETBUDDYINT | UDS_NOTHOUSANDS, 
							theCtrlRect, &m_wndToolBar, IDC_SPIN_VIEWANGLE_TOOLBAR);
	m_Spin_ViewAngle_Ctrl.SetBuddy(&m_Spin_ViewAngle_Value);
	m_Spin_ViewAngle_Ctrl.SetRange(0,90);
	m_Spin_ViewAngle_Ctrl.SetPos(45);
	m_Spin_ViewAngle_Ctrl.SetAccel(1,accelTable);
	m_Spin_ViewAngle_Ctrl.ShowWindow(SW_SHOW);

	/***********************************************/
	/* add spin eye separation control to tool bar */
	/***********************************************/
	spaceRect.left += 4;

	// add eye separation label
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 44;
	spaceRect.left += 44;
	theCtrlRect.DeflateRect(0,1);
	m_Spin_EyeSep_Label.Create(NULL, WS_CHILD | WS_VISIBLE | SS_CENTERIMAGE | SS_BITMAP, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_EYESEP_LABEL);
	m_EyeSep_Bitmap.LoadBitmap(IDB_EYESEP_LABEL);
	m_Spin_EyeSep_Label.SetBitmap((HBITMAP)m_EyeSep_Bitmap.m_hObject);

	// add eye separation value display
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 23;
	spaceRect.left += 23;
	theCtrlRect.DeflateRect(0,3);
	m_Spin_EyeSep_Value.Create("5", WS_CHILD | WS_VISIBLE | SS_RIGHT | SS_SUNKEN, 
								theCtrlRect, &m_wndToolBar, IDC_SPIN_EYESEP_VALUE);
	m_Spin_EyeSep_Value.SetFont(m_Spin_Font);

	// add eye separation spin button
	theCtrlRect = spaceRect;
	theCtrlRect.right = theCtrlRect.left + 22;
	spaceRect.left += 14;
	theCtrlRect.DeflateRect(0,2);
	m_Spin_EyeSep_Ctrl.Create( UDS_SETBUDDYINT | UDS_NOTHOUSANDS, 
							theCtrlRect, &m_wndToolBar, IDC_SPIN_EYESEP_TOOLBAR);
	m_Spin_EyeSep_Ctrl.SetBuddy(&m_Spin_EyeSep_Value);
	m_Spin_EyeSep_Ctrl.SetRange(0,1000);
	m_Spin_EyeSep_Ctrl.SetPos(5);
	m_Spin_EyeSep_Ctrl.SetAccel(1,accelTable);
	m_Spin_EyeSep_Ctrl.ShowWindow(SW_SHOW);

	/**************************************/
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC | CBRS_FLOAT_MULTI);


	/**********************************/
	/* Create and initialize mode bar */
	/**********************************/
	if (!m_wndModeBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP, IDW_MODEBAR) ||
		!m_wndModeBar.LoadToolBar(IDR_MODEBAR))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	m_wndModeBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC | CBRS_FLOAT_MULTI);


	/**********************************/
	/* Create and initialize show bar */
	/**********************************/
	if (!m_wndShowBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP, IDW_SHOWBAR) ||
		!m_wndShowBar.LoadToolBar(IDR_SHOWBAR))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	m_wndShowBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC | CBRS_FLOAT_MULTI);


	/************************************/
	/* Create and initialize status bar */
	/************************************/
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// dynamically size panes according to status font
	CWindowDC	statusDC(&m_wndStatusBar);
	CString		paneString;

	paneString = "Equitorial";
	CSize		coordExt = statusDC.GetTextExtent(paneString);
	paneString = "Cross-eyed";
	CSize		viewModeExt = statusDC.GetTextExtent(paneString);
	paneString = "Scale: 100";
	CSize		scaleExt = statusDC.GetTextExtent(paneString);
	paneString = "Angle: 360";
	CSize		viewAngleExt = statusDC.GetTextExtent(paneString);
	paneString = "Sep: 10.0";
	CSize		sepExt = statusDC.GetTextExtent(paneString);
	paneString = "Lim: 10.0";
	CSize		limExt = statusDC.GetTextExtent(paneString);
	paneString = "Eye: -1.0/-1.0/-1.0";
	CSize		eyeExt = statusDC.GetTextExtent(paneString);

	m_wndStatusBar.SetPaneInfo(1,ID_INDICATOR_COORDTYPE,	SBPS_POPOUT, coordExt.cx);
	m_wndStatusBar.SetPaneInfo(2,ID_INDICATOR_VIEWMODE,		SBPS_POPOUT, viewModeExt.cx);
	m_wndStatusBar.SetPaneInfo(3,ID_INDICATOR_SCALEFACTOR,	SBPS_POPOUT, scaleExt.cx);
	m_wndStatusBar.SetPaneInfo(4,ID_INDICATOR_VIEWANGLE,	SBPS_POPOUT, viewAngleExt.cx);
	m_wndStatusBar.SetPaneInfo(5,ID_INDICATOR_EYESEPARATION,SBPS_POPOUT, sepExt.cx);
	m_wndStatusBar.SetPaneInfo(6,ID_INDICATOR_LINELIMIT,	SBPS_POPOUT, limExt.cx);
	m_wndStatusBar.SetPaneInfo(7,ID_INDICATOR_EYELOC,		SBPS_POPOUT, eyeExt.cx);


	m_wndToolBar.EnableDocking(CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);
	m_wndModeBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndShowBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);

	DockControlBar(&m_wndToolBar);
	DockControlBar(&m_wndModeBar, AFX_IDW_DOCKBAR_BOTTOM);
	DockControlBarLeftOf(&m_wndShowBar, &m_wndModeBar);



	// CG: The following line was added by the Splash Screen component.
//	CSplashWnd::ShowSplashScreen(this);

	return 0;
}

// We override PreCreateWindow to specify a different window class (WNDCLASS),
//   one with a different background and without the CS_VREDRAW/CS_HREDRAW
//   style so all the frame window's control bars will not be repainted
//   when the window is resized.
/***************************************************************************/
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
#ifdef OLD
	ASSERT(cs.lpszClass == NULL);       // must not be specified
	cs.lpszClass = AfxRegisterWndClass(CS_DBLCLKS,
		AfxGetApp()->LoadStandardCursor(IDC_ARROW), (HBRUSH)(COLOR_WINDOW+1),
		AfxGetApp()->LoadIcon(IDR_MAINFRAME));
	return TRUE;
#else
	return CFrameWnd::PreCreateWindow(cs);

#endif
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
/***************************************************************************/
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

/***************************************************************************/
void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


/***************************************************************************/
void CMainFrame::OnViewModebar() 
{
	// toggle visible state
	m_wndModeBar.ShowWindow((m_wndModeBar.GetStyle() & WS_VISIBLE) == 0 ? SW_SHOW : SW_HIDE);
	RecalcLayout();
}

/***************************************************************************/
void CMainFrame::OnUpdateViewModebar(CCmdUI* pCmdUI) 
{
	if ((m_wndModeBar.GetStyle() & WS_VISIBLE) == 0)
		pCmdUI->SetCheck(0);
	else
		pCmdUI->SetCheck(1);
}

/***************************************************************************/
void CMainFrame::OnViewShowbar() 
{
	// toggle visible state
	m_wndShowBar.ShowWindow((m_wndShowBar.GetStyle() & WS_VISIBLE) == 0 ? SW_SHOW : SW_HIDE);
	RecalcLayout();
}

/***************************************************************************/
void CMainFrame::OnUpdateViewShowbar(CCmdUI* pCmdUI) 
{
	if ((m_wndShowBar.GetStyle() & WS_VISIBLE) == 0)
		pCmdUI->SetCheck(0);
	else
		pCmdUI->SetCheck(1);	
}

void CMainFrame::DockControlBarLeftOf(CToolBar* Bar, CToolBar* LeftOf)
{
	CRect rect;
	DWORD dw;
	UINT n;

	// get MFC to adjust the dimensions of all docked ToolBars
	// so that GetWindowRect will be accurate
	RecalcLayout();
	LeftOf->GetWindowRect(&rect);
	rect.OffsetRect(1,0);
	dw=LeftOf->GetBarStyle();
	n = 0;
	n = (dw&CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw&CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw&CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw&CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;

	// When we take the default parameters on rect, DockControlBar will dock
	// each Toolbar on a seperate line.  By calculating a rectangle, we in effect
	// are simulating a Toolbar being dragged to that location and docked.
	DockControlBar(Bar,n,&rect);
}

/***************************************************************************/
void CMainFrame::OnSpinscalePressed(NMHDR* pNMHDR, LRESULT* pResult)
{
	CWnd *pWnd;

	pWnd = GetWindow(GW_CHILD);

	while  ((pWnd != NULL) && (IsChild(pWnd)))
	{
		if (pWnd->IsKindOf(RUNTIME_CLASS(CStereoStarView)) == TRUE)
			((CStereoStarView*) pWnd)->OnSpinscalePressed();
		pWnd = pWnd->GetNextWindow();
	}
}

/***************************************************************************/
void CMainFrame::OnSpinscaleUnpressed(NMHDR* pNMHDR, LRESULT* pResult)
{
	CWnd *pWnd;

	pWnd = GetWindow(GW_CHILD);

	while  ((pWnd != NULL) && (IsChild(pWnd)))
	{
		if (pWnd->IsKindOf(RUNTIME_CLASS(CStereoStarView)) == TRUE)
			((CStereoStarView*) pWnd)->OnSpinscaleUnpressed();
		pWnd = pWnd->GetNextWindow();
	}
}
