// StereoStarDoc.cpp : implementation of the CStereoStarDoc class
//

#include "stdafx.h"
#include "StereoStar.h"

#include "StereoStarDoc.h"
#include "StereoStarView.h"
#include <math.h>
#include "ProgressDialog.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStereoStarDoc

IMPLEMENT_DYNCREATE(CStereoStarDoc, CDocument)

BEGIN_MESSAGE_MAP(CStereoStarDoc, CDocument)
	//{{AFX_MSG_MAP(CStereoStarDoc)
	ON_COMMAND(ID_FILE_LOADVIEW, OnFileLoadview)
	ON_COMMAND(ID_FILE_SAVEVIEW, OnFileSaveview)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStereoStarDoc construction/destruction

/***************************************************************************/
CStereoStarDoc::CStereoStarDoc()
{
	// TODO: add one-time construction code here
	m_sizeDoc[EQUITORIAL] = CSize(800,900);
	m_sizeDoc[GALACTIC] = CSize(800,900);

}
// end CStereoStarDoc::CStereoStarDoc

/***************************************************************************/
CStereoStarDoc::~CStereoStarDoc()
{
}
// end CStereoStarDoc::~CStereoStarDoc

/***************************************************************************/
BOOL CStereoStarDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)


	return TRUE;
}
// end CStereoStarDoc::OnNewDocument

/////////////////////////////////////////////////////////////////////////////
// CStereoStarDoc serialization

/***************************************************************************/
void CStereoStarDoc::Serialize(CArchive& ar)
{

	if (ar.IsStoring())
	{
//		ar << m_sizeDoc;
	}
	else
	{
//		ar >> m_sizeDoc;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CStereoStarDoc diagnostics

#ifdef _DEBUG
/***************************************************************************/
void CStereoStarDoc::AssertValid() const
{
	CDocument::AssertValid();
}

/***************************************************************************/
void CStereoStarDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CStereoStarDoc commands

/***************************************************************************/
BOOL CStereoStarDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	


	CString		thePath(lpszPathName);

	thePath.MakeLower();

	if (thePath.Find(".str") != -1)
		LoadStarDataFile(lpszPathName);

	if (thePath.Find(".vew") != -1)
		LoadViewFile(lpszPathName);

	
	return TRUE;
}
// end CStereoStarDoc::OnOpenDocument

/***************************************************************************/
CString CStereoStarDoc::GetStarName(short starNum) 
{
	StarNode	*newNode;

	newNode = (StarNode*)starList.GetAt(starList.FindIndex(starNum));
	return newNode->starName;
}
// end CStereoStarDoc::GetStarName

/***************************************************************************/
short CStereoStarDoc::GetSpectralClass(short starNum) 
{
	StarNode	*newNode;

	newNode = (StarNode*)starList.GetAt(starList.FindIndex(starNum));
	return newNode->spectralClass;
}
// end CStereoStarDoc::GetSpectralClass

/***************************************************************************/
TriPoint CStereoStarDoc::GetLoc(short starNum, short coordSystem) 
{
	StarNode	*newNode;

	newNode = (StarNode*)starList.GetAt(starList.FindIndex(starNum));
	return newNode->loc[coordSystem];
}
// end CStereoStarDoc::GetLoc

/***************************************************************************/
double CStereoStarDoc::GetOriginDist(short starNum)
{
	StarNode	*newNode;

	newNode = (StarNode*)starList.GetAt(starList.FindIndex(starNum));
	return newNode->originDist;
}

/***************************************************************************/
void CStereoStarDoc::SetOriginDist(short starNum, double newDist)
{
	StarNode	*newNode;

	newNode = (StarNode*)starList.GetAt(starList.FindIndex(starNum));
	newNode->originDist = newDist;

	return;
}

/***************************************************************************/
short CStereoStarDoc::GetNumStars() 
{
	return starList.GetCount();

}
// end CStereoStarDoc::GetSpectralClass


/***************************************************************************/
void CStereoStarDoc::OnCloseDocument() 
{
	// TODO: Add your specialized code here and/or call the base class

	EmptyStarList();
	
	CDocument::OnCloseDocument();
}
// end CStereoStarDoc::OnCloseDocument

/***************************************************************************/
void CStereoStarDoc::EmptyStarList() 
{
	StarNode*	theNode;
	int			starCount = starList.GetCount();

	for (int a = 0; a < starCount; a++) {
		theNode = (StarNode*)starList.GetAt(starList.FindIndex(a));
		delete theNode;
	}
	starList.RemoveAll();

	for (a = 0; a < NUMPLANES; a++)
	{
		for (int b = 0; b < NUMCORNERS; b++)
		{
			for (int c = 0; c < NUMCOORDSYSTEMS; c++)
			{
				plane[a][b][c].x = 0.0;
				plane[a][b][c].y = 0.0;
				plane[a][b][c].z = 0.0;
			}
		}
	}
}
// end CStereoStarDoc::EmptyStarList

/***************************************************************************/
void CStereoStarDoc::OnFileLoadview() 
{
	POSITION			pos = GetFirstViewPosition();
	CStereoStarView*	pFirstView = (CStereoStarView*)GetNextView( pos );
	CFileDialog browseOpenDialog(TRUE, "vew", NULL, OFN_PATHMUSTEXIST | OFN_HIDEREADONLY, 
								  "View files (*.vew)|*.vew||", pFirstView);	

	if (browseOpenDialog.DoModal() == IDOK)
	{
		CString		openPath = browseOpenDialog.GetPathName();
		LoadViewFile(openPath);
	}
}
// end CStereoStarDoc::OnFileLoadview

/***************************************************************************/
void CStereoStarDoc::OnFileSaveview() 
{
	POSITION			pos = GetFirstViewPosition();
	CStereoStarView*	pFirstView = (CStereoStarView*)GetNextView( pos );
	CFileDialog browseOpenDialog(FALSE, "vew", NULL, OFN_CREATEPROMPT | OFN_OVERWRITEPROMPT| OFN_HIDEREADONLY, 
								  "View files (*.vew)|*.vew||", pFirstView);	

	if (browseOpenDialog.DoModal() == IDOK)
	{
		CString		openPath = browseOpenDialog.GetPathName();
		SaveViewFile(openPath);
	}
}
// end CStereoStarDoc::OnFileSaveview

/***************************************************************************/
CSize CStereoStarDoc::GetDocSize(short coordSystem)
{ 
	return m_sizeDoc[coordSystem]; 
}
// end CStereoStarDoc::GetDocSize

/***************************************************************************/
void CStereoStarDoc::LoadViewFile(LPCTSTR lpszPathName)
{
	POSITION			pos = GetFirstViewPosition();
	CStereoStarView*	pFirstView = (CStereoStarView*)GetNextView( pos );
	CFile				theFile;

	theFile.Open(lpszPathName, CFile::modeRead);
	CArchive	archive(&theFile, CArchive::load);

	archive >> starFile;
	LoadStarDataFile(starFile);

	pFirstView->Serialize(archive);
}
// end CStereoStarDoc::LoadViewFile

/***************************************************************************/
void CStereoStarDoc::SaveViewFile(LPCTSTR lpszPathName)
{
	POSITION			pos = GetFirstViewPosition();
	CStereoStarView*	pFirstView = (CStereoStarView*)GetNextView( pos );
	CFile				theFile;

	theFile.Open(lpszPathName, CFile::modeCreate | CFile::modeWrite);
	CArchive	archive(&theFile, CArchive::store);

	archive << starFile;
	pFirstView->Serialize(archive);
}
// end CStereoStarDoc::SaveViewFile

/***************************************************************************/
void CStereoStarDoc::LoadStarDataFile(LPCTSTR lpszPathName)
{
	starFile = lpszPathName;

	CStdioFile	datafile(lpszPathName, CFile::modeRead);
	CProgressDialog	dlg;
	CString		instring;
	StarNode	*newNode;
	char		*stopString;
	TriPoint	plus[NUMCOORDSYSTEMS];
	TriPoint	minus[NUMCOORDSYSTEMS];
	short		maxStar = 0;
	short		totalStars = 0;
	CString		errorString;
	double		leftX, rightX, upperY, lowerY;

	EmptyStarList();

	while (datafile.ReadString(instring))
		totalStars++;
	datafile.SeekToBegin();

	dlg.Create(IDD_PROGRESS_DIALOG, NULL);
	dlg.range = totalStars;
	dlg.labelText = "Loading Star #";

	plus[EQUITORIAL].x = 0.0;
	plus[EQUITORIAL].y = 0.0;
	plus[EQUITORIAL].z = 0.0;
	plus[GALACTIC].x = 0.0;
	plus[GALACTIC].y = 0.0;
	plus[GALACTIC].z = 0.0;

	TRY
	{
		while (datafile.ReadString(instring))
		{
			maxStar++;
			dlg.StepIt();
			newNode = new StarNode;

			newNode->starName = instring.Mid(11, (41-11));
			newNode->loc[EQUITORIAL].x = strtod(instring.Mid(77, (85-77)+1), &stopString);
			newNode->loc[EQUITORIAL].y = strtod(instring.Mid(86, (94-86)+1), &stopString);
			newNode->loc[EQUITORIAL].z = strtod(instring.Mid(95, (103-95)+1), &stopString);
			newNode->loc[GALACTIC].x = strtod(instring.Mid(104, (112-104)+1), &stopString);
			newNode->loc[GALACTIC].y = strtod(instring.Mid(113, (121-113)+1), &stopString);
			newNode->loc[GALACTIC].z = strtod(instring.Mid(122, (130-122)+1), &stopString);
			switch(toupper(instring[57]))
			{
			case 'O':	newNode->spectralClass = CLASS_O;	break;
			case 'B':	newNode->spectralClass = CLASS_B;	break;
			case 'A':	newNode->spectralClass = CLASS_A;	break;
			case 'F':	newNode->spectralClass = CLASS_F;	break;
			case 'G':	newNode->spectralClass = CLASS_G;	break;
			case 'K':	newNode->spectralClass = CLASS_K;	break;
			case 'M':	newNode->spectralClass = CLASS_M;	break;
			default:	newNode->spectralClass = CLASS_X;	break;
			}

			newNode->originDist = 0.0;

			// Add the new node sorted alpha by starname
			if (starList.IsEmpty())
			{
				starList.AddTail(newNode);
			}
			else
			{
				POSITION pos1 = starList.GetHeadPosition();
				POSITION pos2;
				BOOL	yetToBeInserted = TRUE;
				while( pos1 != NULL )
				{
					pos2 = pos1;
					StarNode* theStarNode = (StarNode*)(starList.GetNext( pos1 ));
					if (theStarNode->starName > newNode->starName)
					{
						starList.InsertBefore(pos2, newNode);
						yetToBeInserted = FALSE;
						break;
					}
				}
				if (yetToBeInserted)
					starList.AddTail(newNode);
			}

			// get the bounding box co-ordinates
			for (int a = 0; a < NUMCOORDSYSTEMS; a++)
			{
				if (plus[ a].x < newNode->loc[a].x)	plus[ a].x = newNode->loc[a].x;
				if (minus[a].x > newNode->loc[a].x)	minus[a].x = newNode->loc[a].x;
				if (plus[ a].y < newNode->loc[a].y)	plus[ a].y = newNode->loc[a].y;
				if (minus[a].y > newNode->loc[a].y)	minus[a].y = newNode->loc[a].y;
				if (plus[ a].z < newNode->loc[a].z)	plus[ a].z = newNode->loc[a].z;
				if (minus[a].z > newNode->loc[a].z)	minus[a].z = newNode->loc[a].z;
			}
		}
	}
	CATCH(CMemoryException, MemEx)
	{
		errorString.Format("Out of memory error while loading star #%d",maxStar);
		::AfxMessageBox(errorString, MB_OK | MB_ICONEXCLAMATION );
		return;
	}
	END_CATCH

	// Calculate the x-y, x-z, and y-z planes
	for (int a = 0; a < NUMCOORDSYSTEMS; a++)
	{
		// round further from origin
		plus[a].x = ceil(plus[a].x);
		plus[a].y = ceil(plus[a].y);
		plus[a].z = ceil(plus[a].z);
		minus[a].x = floor(minus[a].x);
		minus[a].y = floor(minus[a].y);
		minus[a].z = floor(minus[a].z);
		// insure that the origin is always at the center
		if (plus[a].x < -(minus[a].x))	plus[a].x = -(minus[a].x);
		else							minus[a].x = -(plus[a].x);
		if (plus[a].y < -(minus[a].y))	plus[a].y = -(minus[a].y);
		else							minus[a].y = -(plus[a].y);
		if (plus[a].z < -(minus[a].z))	plus[a].z = -(minus[a].z);
		else							minus[a].z = -(plus[a].z);
		// calculate other co-ords
		//    x-y plane
		plane[XY][UPPERLEFT ][a].x = minus[a].x;
		plane[XY][UPPERLEFT ][a].y = plus[ a].y;
		plane[XY][UPPERLEFT ][a].z = 0.0;
		plane[XY][LOWERRIGHT][a].x = plus[ a].x;
		plane[XY][LOWERRIGHT][a].y = minus[a].y;
		plane[XY][LOWERRIGHT][a].z = 0.0;
		plane[XY][UPPERRIGHT][a].x = plus[ a].x;
		plane[XY][UPPERRIGHT][a].y = plus[ a].y;
		plane[XY][UPPERRIGHT][a].z = 0.0;
		plane[XY][LOWERLEFT ][a].x = minus[a].x;
		plane[XY][LOWERLEFT ][a].y = minus[a].y;
		plane[XY][LOWERLEFT ][a].z = 0.0;
		//    x-z plane
		plane[XZ][UPPERLEFT ][a].x = minus[a].x;
		plane[XZ][UPPERLEFT ][a].y = 0.0;
		plane[XZ][UPPERLEFT ][a].z = plus[ a].z;
		plane[XZ][LOWERRIGHT][a].x = plus[ a].x;
		plane[XZ][LOWERRIGHT][a].y = 0.0;
		plane[XZ][LOWERRIGHT][a].z = minus[a].z;
		plane[XZ][UPPERRIGHT][a].x = plus[ a].x;
		plane[XZ][UPPERRIGHT][a].y = 0.0;
		plane[XZ][UPPERRIGHT][a].z = plus[ a].z;
		plane[XZ][LOWERLEFT ][a].x = minus[a].x;
		plane[XZ][LOWERLEFT ][a].y = 0.0;
		plane[XZ][LOWERLEFT ][a].z = minus[a].z;
		//    y-z plane
		plane[YZ][UPPERLEFT ][a].x = 0.0;
		plane[YZ][UPPERLEFT ][a].y = plus[ a].y;
		plane[YZ][UPPERLEFT ][a].z = plus[ a].z;
		plane[YZ][LOWERRIGHT][a].x = 0.0;
		plane[YZ][LOWERRIGHT][a].y = minus[a].y;
		plane[YZ][LOWERRIGHT][a].z = minus[a].z;
		plane[YZ][UPPERRIGHT][a].x = 0.0;
		plane[YZ][UPPERRIGHT][a].y = plus[ a].y;
		plane[YZ][UPPERRIGHT][a].z = minus[a].z;
		plane[YZ][LOWERLEFT ][a].x = 0.0;
		plane[YZ][LOWERLEFT ][a].y = minus[a].y;
		plane[YZ][LOWERLEFT ][a].z = plus[ a].z;
	}

	// this does not take into account the scaling factor.
	// the CStereoStarView class gets m_sizeDoc via CStereoStarDoc::GetDocSize()
	// then the view scales it by the scaling factor
	leftX  = floor(plane[XY][UPPERLEFT ][EQUITORIAL].x);
	rightX = ceil( plane[XY][LOWERRIGHT][EQUITORIAL].x);
	upperY = ceil( plane[XY][UPPERLEFT ][EQUITORIAL].y);
	lowerY = floor(plane[XY][LOWERRIGHT][EQUITORIAL].y);
	m_sizeDoc[EQUITORIAL] = CSize(
		(int)((rightX - leftX) + 1.0),
		(int)((upperY - lowerY) + 1.0));
	leftX  = floor(plane[XY][UPPERLEFT ][GALACTIC].x);
	rightX = ceil( plane[XY][LOWERRIGHT][GALACTIC].x);
	upperY = ceil( plane[XY][UPPERLEFT ][GALACTIC].y);
	lowerY = floor(plane[XY][LOWERRIGHT][GALACTIC].y);
	m_sizeDoc[GALACTIC] = CSize(
		(int)((rightX - leftX) + 1.0),
		(int)((upperY - lowerY) + 1.0));

	dlg.DestroyWindow();
	datafile.Close();

	
	POSITION pos = GetFirstViewPosition();
	CStereoStarView* pFirstView = (CStereoStarView*)GetNextView( pos );

	pFirstView->GetAxis();
	pFirstView->CalcLine();
	pFirstView->CalcEye();
	pFirstView->CalcOriginDist();

}
// end CStereoStarDoc::LoadStarDataFile

