/*****************************************************************************
*
*	CStarLine.h : header file for CStarLine class
*
*	Original programming:	Winchell Chung	8/19/1998
*	Changes:				
*
*=========== Copyright (C) 1998 Praeternatural Tower Productions ===========*/

#ifndef _CSTARLINE_H_
#define _CSTARLINE_H_

/////////////////////////////////////////////////////////////////////////////
//	CStarLine
//
//	This data structure holds the information specifying one line
//  between two stars, and can serialize itself.

class CStarLine : public CObject
{
    DECLARE_SERIAL( CStarLine )
// Operations
public:
	void Serialize( CArchive& ar);
    const CStarLine& operator=( const CStarLine& s );
    BOOL operator==(CStarLine s);

// Constructors
public:
	CStarLine();
	CStarLine(short startStar, short endStar, double distance);
	CStarLine(const CStarLine& s);

// Destructors
public:
	virtual ~CStarLine();

// Attributes
public:
	short m_lStartStar;
	short m_lEndStar;
	double m_dDistance;
};

#endif // _CSTARLINE_H_
