/*****************************************************************************
*
*	CStarLine.cpp : the implementation file for the CStarLine class
*
*	Original programming:	Winchell Chung	8/19/1998
*	Changes:				
*
*=========== Copyright (C) 1998 Praeternatural Tower Productions ===========*/

#include "stdafx.h"
#include "CStarLine.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CStarLine, CObject, 0x101)

/*****************************************************************************
*	Operations
*****************************************************************************/

/***************************************************************************/
void CStarLine::Serialize( CArchive& ar)
{
	CObject::Serialize( ar );

	if (ar.IsStoring())
	{
		ar << m_lStartStar;
		ar << m_lEndStar;
		ar << m_dDistance;
	}
	else
	{
		ar >> m_lStartStar;
		ar >> m_lEndStar;
		ar >> m_dDistance;
	}
}

/***************************************************************************/
const CStarLine& CStarLine::operator=( const CStarLine& s)
{
	m_lStartStar	= s.m_lStartStar;
	m_lEndStar		= s.m_lEndStar;
	m_dDistance		= s.m_dDistance;

	return *this;
}

/***************************************************************************/
BOOL CStarLine::operator==( CStarLine s)
{
	BOOL	isEqual = TRUE;

	if (m_lStartStar	!= s.m_lStartStar)	isEqual = FALSE;
	if (m_lEndStar		!= s.m_lEndStar)	isEqual = FALSE;
	if (m_dDistance		!= s.m_dDistance)	isEqual = FALSE;

	return isEqual;
}

/*****************************************************************************
*	Constructors
*****************************************************************************/
CStarLine::CStarLine()
{
	m_lStartStar	= 0;
	m_lEndStar		= 0;
	m_dDistance		= 0.0;
}
// end CStarLine::CStarLine

/***************************************************************************/
CStarLine::CStarLine(short startStar, short endStar, double distance)
{
	m_lStartStar	= startStar;
	m_lEndStar		= endStar;
	m_dDistance		= distance;
}
// end CStarLine::CStarLine

/***************************************************************************/
CStarLine::CStarLine(const CStarLine& s)
{
	m_lStartStar	= s.m_lStartStar;
	m_lEndStar		= s.m_lEndStar;
	m_dDistance		= s.m_dDistance;
}
// end CStarLine::CStarLine

/*****************************************************************************
*	Destructors
*****************************************************************************/
CStarLine::~CStarLine()
{
}
// end CStarLine::~CStarLine

